(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    143457,       3345]
NotebookOptionsPosition[    142706,       3317]
NotebookOutlinePosition[    143048,       3332]
CellTagsIndexPosition[    143005,       3329]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"SetDirectory", "[", 
  "\"\<E:\\\\Presentations\\\\BAO\\\\Amas 21cm\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.510476938668167*^9, 3.510476985578858*^9}}],

Cell[BoxData[
 RowBox[{"\"\<E:\\\\Presentations\\\\BAO\\\\Amas 21cm\>\"", 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.5104796472910023`*^9, 3.510479647329006*^9}}],

Cell[BoxData[
 RowBox[{"<<", "Calendar`"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"calE", "=", 
   RowBox[{"Import", "[", 
    RowBox[{"\"\<calib1410MhzEst.txt\>\"", ",", "\"\<Table\>\""}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.510477004775777*^9, 3.5104770327775774`*^9}, 
   3.5104796641066837`*^9}],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<ErrorBarPlots`\>\"", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"calib1410E", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"DaysBetween", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"2001", ",", "1", ",", "31"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Quotient", "[", 
              RowBox[{
               RowBox[{"calE", "[", 
                RowBox[{"[", 
                 RowBox[{"n", ",", "1"}], "]"}], "]"}], ",", "10000"}], "]"}],
              ",", 
             RowBox[{"Quotient", "[", 
              RowBox[{
               RowBox[{"Mod", "[", 
                RowBox[{
                 RowBox[{"calE", "[", 
                  RowBox[{"[", 
                   RowBox[{"n", ",", "1"}], "]"}], "]"}], ",", "10000"}], 
                "]"}], ",", "100"}], "]"}], ",", 
             RowBox[{"Mod", "[", 
              RowBox[{
               RowBox[{"Mod", "[", 
                RowBox[{
                 RowBox[{"calE", "[", 
                  RowBox[{"[", 
                   RowBox[{"n", ",", "1"}], "]"}], "]"}], ",", "10000"}], 
                "]"}], ",", "100"}], "]"}]}], "}"}]}], "]"}], ",", 
         RowBox[{"calE", "[", 
          RowBox[{"[", 
           RowBox[{"n", ",", "4"}], "]"}], "]"}]}], "}"}], ",", 
       RowBox[{"ErrorBar", "[", 
        RowBox[{"calE", "[", 
         RowBox[{"[", 
          RowBox[{"n", ",", "5"}], "]"}], "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "1", ",", 
       RowBox[{"Length", "[", "calE", "]"}]}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.5104791154288216`*^9, 3.5104792136746454`*^9}, {
   3.5104794276190376`*^9, 3.510479462387514*^9}, {3.5104795078190565`*^9, 
   3.5104795230085754`*^9}, {3.510479696741947*^9, 3.5104797137656493`*^9}, {
   3.5104797708871665`*^9, 3.5104798644921665`*^9}, {3.5104804469899735`*^9, 
   3.5104804931435885`*^9}, {3.5104807894052114`*^9, 3.5104807965499263`*^9}, 
   3.510481177569024*^9, {3.5104812112353907`*^9, 3.5104812129575624`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ErrorListPlot", "[", 
  RowBox[{"calib1410E", ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"All", ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "25"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"PlotMarkers", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"LabelStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Blue", ",", "Large"}], "]"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<Coeff. calibration Est (Jy)\>\"", ",", "\"\<\>\""}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<Jour depuis 31 Jan. 2001\>\"", ",", "\"\<1410 MHz\>\""}], 
       "}"}]}], "}"}]}], ",", 
   RowBox[{"GridLines", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5104799048761663`*^9, 3.5104799158091664`*^9}, {
   3.5104805016334376`*^9, 3.5104805044697213`*^9}, {3.5104805847837515`*^9, 
   3.510480625982871*^9}, {3.510480703264599*^9, 3.5104808107683477`*^9}, {
   3.5104808997272425`*^9, 3.510480932329503*^9}, {3.5104809724915185`*^9, 
   3.5104809899842677`*^9}, {3.5104811305463223`*^9, 3.51048115321859*^9}, 
   3.510481217748042*^9, 3.5104815136136255`*^9}],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJztVv1P1WUUv5JzxsgpMHOOfJsljrdL6pQ59RBgapqIRAzJMUYbY7ylAQoo
KAISovF+5RLcy71w78VbM+ecNSMyMjVNUpKVZjStLHwBykQk6/t8z+e5t9vf
cL+/fPfZOc95zjnP57zMTc6KedNDo9GsnqDRiL/82qJO/PG3bygxCqTVCuzb
oQWOosr0Xx/bpr3ImDbTIvFdgX53Ai3Z+vFaLw/IB5KodHDTyVlRUj+FElKW
/7gxSMpTqHP48obkqaEO/Gry1Piw476Mk9KpIUK5cQvuT8qi5yftqY8IkP5t
I12md0n3ech7t9O1R7vTTsVK/RzKEuJwJ46uasz0fsoH/uaQ7wcv/5TfB3l3
Hn0x5+i21A+Bi3dSV+vMkB8icV9xAR06/cA/8RLkUwspdLLdL8HsxB36njlH
R7yhv4tGRHijkGcXcfwZsOdfTMpt1XcLtQ78pG/Hby+Ewj9dMW0X4n8gf3cP
8onz+/e6xp9aQleU6+I/At5RQkoyz+auhL3sfdRy33LmlX7Io8tIpLMyEPaG
yqjflL3C83WtAyveVjXeQzxryknxZtWSJ5CPlvP7aXF+cgXH977kSyUlioT5
QW6o5PeV73O7iuO/LvN/kMqnf/f1w0XQ7z1IRWmn3q6N1zrwXHEgA/EMHCLx
fL7B8v5qSvq5d961ndD3qubzOuj3VlPtjIlxU+5CPr+GRHq6ipxY0VY0oB9d
Q3/5KxF8K/2rIU+RoE5gqnXNt70W/Jf8rOPzr2kdWM1HIuwvqyPh7qNZkg/1
bC8MOKmehpTnWnoOuKeexnaLgHwcOG5K0LH3NsK+XwPF3mxXGAj95gb67Lwx
6oTM50AD128o9Pc1Mv4GeLyR+dUOXKij9UsrwpNKgc06Miv06I8ANuhIvU4L
f8Z1JLyb0QP5rcOu77umiaxKOBVzJf+a6NLDzTfbHwOnNFHMyVmlg9KfeD3X
l7S3X8/+voX+cEBPIvz7CyDv0TPfu+R9zVzfx4HTm2mdl0dA+dUQxqnNnN+n
ZT6bub8MQn9ZC5/3BV7cQl8ZRYNEPdhbON/FMp+tJOhf9WyIA68QhPkE+rpW
ro+L0Pc0uPIp0kAiHEsHcL4B/Apx4DubRIJgb6+BFogEzZT910BfKukNN0i+
GUmkL0UPvNJInz8QhASONXJ9T3HiALUAYT/XSGo7ToX8dyPztQv+3DbSrlUK
489Bf8jo2s8C20hcv/xTmf82unhB+dYDW9vIoLTX+WXAp9soVW0wsD/PxPEl
QJ5sInUcLZT9zUSjCn30kSEOrM6LAvjTbOJ+HQL96ybuf3myXszcb3yAg83c
T9fBXqAZ9QZ7MWbuHxtkPzZzPZigf8HM9TAE/IuZ+91i4Ftm7p9bYa+snfMz
G/Zq2pnvKcEO/JxKGOiPt1OBIOSY9K+DMpRyGI7xdmCW4zx18PxYBfu5/8N/
Ql/yZ6yD+f2G7O8d9JJoqFtQH4EWEuOzRAP9NItrvbZZ+H3vAJ+xcD6ynZjr
dxrjexbm0w3Zf62Upw5c4DIrNR1WvjAnVudpPPxpsfJ8nwB/rlu5/0wE9rZR
jniwg/K9ba79Oc7G80/6W2cjkc7Lcj702kixboyaDv1bNubHO5BP6uR9QcYf
2UminDKPyf7ZSaJ8zl6V/bWT4x+W9XAE9evE3uqFiC//CM8vuT+MHKGF6gCB
P752ni850J9hZ//SZP3ZSZTn2gPyveyk7nexwFY796NnZP7sPF+DcP57O43b
xICH/Rt2mi0GhHwvjXtfdO+L7n3RvS+690V+H/e+6N4X3fuie19074sq/s++
+C+KuRHD
   "], {
    {Hue[0.67, 0.6, 0.6], {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 164], {LineBox[{{0., 17.85}, {0., 16.314}}], 
       LineBox[{
        Offset[{1.5, 0}, {0., 17.85}], Offset[{-1.5, 0}, {0., 17.85}]}], 
       LineBox[{
        Offset[{1.5, 0}, {0., 16.314}], Offset[{-1.5, 0}, {0., 16.314}]}]}}, {
      InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 165], {
       LineBox[{{14., 16.497}, {14., 16.447000000000003`}}], 
       LineBox[{
        Offset[{1.5, 0}, {14., 16.497}], Offset[{-1.5, 0}, {14., 16.497}]}], 
       LineBox[{
        Offset[{1.5, 0}, {14., 16.447000000000003`}], 
         Offset[{-1.5, 0}, {14., 16.447000000000003`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 166], {
       LineBox[{{42., 18.355}, {42., 17.782999999999998`}}], 
       LineBox[{
        Offset[{1.5, 0}, {42., 18.355}], Offset[{-1.5, 0}, {42., 18.355}]}], 
       LineBox[{
        Offset[{1.5, 0}, {42., 17.782999999999998`}], 
         Offset[{-1.5, 0}, {42., 17.782999999999998`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 167], {LineBox[{{77., 18.093}, {77., 17.557}}], 
       LineBox[{
        Offset[{1.5, 0}, {77., 18.093}], Offset[{-1.5, 0}, {77., 18.093}]}], 
       LineBox[{
        Offset[{1.5, 0}, {77., 17.557}], 
         Offset[{-1.5, 0}, {77., 17.557}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 168], {LineBox[{{107., 18.211}, {107., 17.805}}], 
       LineBox[{
        Offset[{1.5, 0}, {107., 18.211}], Offset[{-1.5, 0}, {107., 18.211}]}],
        LineBox[{
        Offset[{1.5, 0}, {107., 17.805}], 
         Offset[{-1.5, 0}, {107., 17.805}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 169], {
       LineBox[{{135., 18.294999999999998`}, {135., 18.245}}], 
       LineBox[{
        Offset[{1.5, 0}, {135., 18.294999999999998`}], 
         Offset[{-1.5, 0}, {135., 18.294999999999998`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {135., 18.245}], 
         Offset[{-1.5, 0}, {135., 18.245}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 170], {LineBox[{{162., 18.39}, {162., 17.964}}], 
       LineBox[{
        Offset[{1.5, 0}, {162., 18.39}], Offset[{-1.5, 0}, {162., 18.39}]}], 
       LineBox[{
        Offset[{1.5, 0}, {162., 17.964}], 
         Offset[{-1.5, 0}, {162., 17.964}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 171], {LineBox[{{167., 17.945}, {167., 16.183}}], 
       LineBox[{
        Offset[{1.5, 0}, {167., 17.945}], Offset[{-1.5, 0}, {167., 17.945}]}],
        LineBox[{
        Offset[{1.5, 0}, {167., 16.183}], 
         Offset[{-1.5, 0}, {167., 16.183}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 172], {LineBox[{{167., 5.309}, {167., 5.043}}], 
       LineBox[{
        Offset[{1.5, 0}, {167., 5.309}], Offset[{-1.5, 0}, {167., 5.309}]}], 
       LineBox[{
        Offset[{1.5, 0}, {167., 5.043}], 
         Offset[{-1.5, 0}, {167., 5.043}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 173], {
       LineBox[{{227., 16.900000000000002`}, {227., 15.818000000000001`}}], 
       LineBox[{
        Offset[{1.5, 0}, {227., 16.900000000000002`}], 
         Offset[{-1.5, 0}, {227., 16.900000000000002`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {227., 15.818000000000001`}], 
         Offset[{-1.5, 0}, {227., 15.818000000000001`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 174], {LineBox[{{251., 17.25}, {251., 17.088}}], 
       LineBox[{
        Offset[{1.5, 0}, {251., 17.25}], Offset[{-1.5, 0}, {251., 17.25}]}], 
       LineBox[{
        Offset[{1.5, 0}, {251., 17.088}], 
         Offset[{-1.5, 0}, {251., 17.088}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 175], {
       LineBox[{{288., 16.808}, {288., 16.776000000000003`}}], 
       LineBox[{
        Offset[{1.5, 0}, {288., 16.808}], Offset[{-1.5, 0}, {288., 16.808}]}],
        LineBox[{
        Offset[{1.5, 0}, {288., 16.776000000000003`}], 
         Offset[{-1.5, 0}, {288., 16.776000000000003`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 176], {LineBox[{{317., 16.426}, {317., 16.236}}], 
       LineBox[{
        Offset[{1.5, 0}, {317., 16.426}], Offset[{-1.5, 0}, {317., 16.426}]}],
        LineBox[{
        Offset[{1.5, 0}, {317., 16.236}], 
         Offset[{-1.5, 0}, {317., 16.236}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 177], {
       LineBox[{{342., 16.928}, {342., 15.586000000000002`}}], 
       LineBox[{
        Offset[{1.5, 0}, {342., 16.928}], Offset[{-1.5, 0}, {342., 16.928}]}],
        LineBox[{
        Offset[{1.5, 0}, {342., 15.586000000000002`}], 
         Offset[{-1.5, 0}, {342., 15.586000000000002`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 178], {LineBox[{{342., 4.809}, {342., 4.697}}], 
       LineBox[{
        Offset[{1.5, 0}, {342., 4.809}], Offset[{-1.5, 0}, {342., 4.809}]}], 
       LineBox[{
        Offset[{1.5, 0}, {342., 4.697}], 
         Offset[{-1.5, 0}, {342., 4.697}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 179], {
       LineBox[{{348., 16.988999999999997`}, {348., 16.671}}], 
       LineBox[{
        Offset[{1.5, 0}, {348., 16.988999999999997`}], 
         Offset[{-1.5, 0}, {348., 16.988999999999997`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {348., 16.671}], 
         Offset[{-1.5, 0}, {348., 16.671}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 180], {
       LineBox[{{380., 16.761000000000003`}, {380., 16.625}}], 
       LineBox[{
        Offset[{1.5, 0}, {380., 16.761000000000003`}], 
         Offset[{-1.5, 0}, {380., 16.761000000000003`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {380., 16.625}], 
         Offset[{-1.5, 0}, {380., 16.625}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 181], {
       LineBox[{{408., 17.387999999999998`}, {408., 17.15}}], 
       LineBox[{
        Offset[{1.5, 0}, {408., 17.387999999999998`}], 
         Offset[{-1.5, 0}, {408., 17.387999999999998`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {408., 17.15}], 
         Offset[{-1.5, 0}, {408., 17.15}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 182], {
       LineBox[{{440., 16.974}, {440., 16.645999999999997`}}], 
       LineBox[{
        Offset[{1.5, 0}, {440., 16.974}], Offset[{-1.5, 0}, {440., 16.974}]}],
        LineBox[{
        Offset[{1.5, 0}, {440., 16.645999999999997`}], 
         Offset[{-1.5, 0}, {440., 16.645999999999997`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 183], {LineBox[{{449., 17.348}, {449., 15.936}}], 
       LineBox[{
        Offset[{1.5, 0}, {449., 17.348}], Offset[{-1.5, 0}, {449., 17.348}]}],
        LineBox[{
        Offset[{1.5, 0}, {449., 15.936}], 
         Offset[{-1.5, 0}, {449., 15.936}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 184], {LineBox[{{449., 4.764}, {449., 4.71}}], 
       LineBox[{
        Offset[{1.5, 0}, {449., 4.764}], Offset[{-1.5, 0}, {449., 4.764}]}], 
       LineBox[{
        Offset[{1.5, 0}, {449., 4.71}], Offset[{-1.5, 0}, {449., 4.71}]}]}}, {
      InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 185], {
       LineBox[{{472., 17.025000000000002`}, {472., 16.913}}], 
       LineBox[{
        Offset[{1.5, 0}, {472., 17.025000000000002`}], 
         Offset[{-1.5, 0}, {472., 17.025000000000002`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {472., 16.913}], 
         Offset[{-1.5, 0}, {472., 16.913}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 186], {LineBox[{{503., 17.657}, {503., 17.197}}], 
       LineBox[{
        Offset[{1.5, 0}, {503., 17.657}], Offset[{-1.5, 0}, {503., 17.657}]}],
        LineBox[{
        Offset[{1.5, 0}, {503., 17.197}], 
         Offset[{-1.5, 0}, {503., 17.197}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 187], {
       LineBox[{{517., 17.125}, {517., 15.850999999999999`}}], 
       LineBox[{
        Offset[{1.5, 0}, {517., 17.125}], Offset[{-1.5, 0}, {517., 17.125}]}],
        LineBox[{
        Offset[{1.5, 0}, {517., 15.850999999999999`}], 
         Offset[{-1.5, 0}, {517., 15.850999999999999`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 188], {
       LineBox[{{517., 4.826}, {517., 4.7700000000000005`}}], 
       LineBox[{
        Offset[{1.5, 0}, {517., 4.826}], Offset[{-1.5, 0}, {517., 4.826}]}], 
       LineBox[{
        Offset[{1.5, 0}, {517., 4.7700000000000005`}], 
         Offset[{-1.5, 0}, {517., 4.7700000000000005`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 189], {
       LineBox[{{531., 17.034000000000002`}, {531., 16.962}}], 
       LineBox[{
        Offset[{1.5, 0}, {531., 17.034000000000002`}], 
         Offset[{-1.5, 0}, {531., 17.034000000000002`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {531., 16.962}], 
         Offset[{-1.5, 0}, {531., 16.962}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 190], {LineBox[{{562., 17.291}, {562., 17.249}}], 
       LineBox[{
        Offset[{1.5, 0}, {562., 17.291}], Offset[{-1.5, 0}, {562., 17.291}]}],
        LineBox[{
        Offset[{1.5, 0}, {562., 17.249}], 
         Offset[{-1.5, 0}, {562., 17.249}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 191], {
       LineBox[{{593., 16.847}, {593., 16.737000000000002`}}], 
       LineBox[{
        Offset[{1.5, 0}, {593., 16.847}], Offset[{-1.5, 0}, {593., 16.847}]}],
        LineBox[{
        Offset[{1.5, 0}, {593., 16.737000000000002`}], 
         Offset[{-1.5, 0}, {593., 16.737000000000002`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 192], {LineBox[{{621., 17.522}, {621., 15.926}}], 
       LineBox[{
        Offset[{1.5, 0}, {621., 17.522}], Offset[{-1.5, 0}, {621., 17.522}]}],
        LineBox[{
        Offset[{1.5, 0}, {621., 15.926}], 
         Offset[{-1.5, 0}, {621., 15.926}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 193], {LineBox[{{623., 4.927}, {623., 4.695}}], 
       LineBox[{
        Offset[{1.5, 0}, {623., 4.927}], Offset[{-1.5, 0}, {623., 4.927}]}], 
       LineBox[{
        Offset[{1.5, 0}, {623., 4.695}], 
         Offset[{-1.5, 0}, {623., 4.695}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 194], {LineBox[{{654., 16.983}, {654., 16.699}}], 
       LineBox[{
        Offset[{1.5, 0}, {654., 16.983}], Offset[{-1.5, 0}, {654., 16.983}]}],
        LineBox[{
        Offset[{1.5, 0}, {654., 16.699}], 
         Offset[{-1.5, 0}, {654., 16.699}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 195], {LineBox[{{714., 17.208}, {714., 17.14}}], 
       LineBox[{
        Offset[{1.5, 0}, {714., 17.208}], Offset[{-1.5, 0}, {714., 17.208}]}],
        LineBox[{
        Offset[{1.5, 0}, {714., 17.14}], 
         Offset[{-1.5, 0}, {714., 17.14}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 196], {LineBox[{{734., 17.009}, {734., 15.671}}], 
       LineBox[{
        Offset[{1.5, 0}, {734., 17.009}], Offset[{-1.5, 0}, {734., 17.009}]}],
        LineBox[{
        Offset[{1.5, 0}, {734., 15.671}], 
         Offset[{-1.5, 0}, {734., 15.671}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 197], {
       LineBox[{{734., 4.8}, {734., 4.6659999999999995`}}], 
       LineBox[{
        Offset[{1.5, 0}, {734., 4.8}], Offset[{-1.5, 0}, {734., 4.8}]}], 
       LineBox[{
        Offset[{1.5, 0}, {734., 4.6659999999999995`}], 
         Offset[{-1.5, 0}, {734., 4.6659999999999995`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 198], {
       LineBox[{{745., 17.107}, {745., 16.878999999999998`}}], 
       LineBox[{
        Offset[{1.5, 0}, {745., 17.107}], Offset[{-1.5, 0}, {745., 17.107}]}],
        LineBox[{
        Offset[{1.5, 0}, {745., 16.878999999999998`}], 
         Offset[{-1.5, 0}, {745., 16.878999999999998`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 199], {LineBox[{{767., 17.255}, {767., 17.123}}], 
       LineBox[{
        Offset[{1.5, 0}, {767., 17.255}], Offset[{-1.5, 0}, {767., 17.255}]}],
        LineBox[{
        Offset[{1.5, 0}, {767., 17.123}], 
         Offset[{-1.5, 0}, {767., 17.123}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 200], {LineBox[{{801., 16.711}, {801., 16.643}}], 
       LineBox[{
        Offset[{1.5, 0}, {801., 16.711}], Offset[{-1.5, 0}, {801., 16.711}]}],
        LineBox[{
        Offset[{1.5, 0}, {801., 16.643}], 
         Offset[{-1.5, 0}, {801., 16.643}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 201], {LineBox[{{864., 17.247}, {864., 16.973}}], 
       LineBox[{
        Offset[{1.5, 0}, {864., 17.247}], Offset[{-1.5, 0}, {864., 17.247}]}],
        LineBox[{
        Offset[{1.5, 0}, {864., 16.973}], 
         Offset[{-1.5, 0}, {864., 16.973}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 202], {
       LineBox[{{884., 17.009}, {884., 15.649000000000001`}}], 
       LineBox[{
        Offset[{1.5, 0}, {884., 17.009}], Offset[{-1.5, 0}, {884., 17.009}]}],
        LineBox[{
        Offset[{1.5, 0}, {884., 15.649000000000001`}], 
         Offset[{-1.5, 0}, {884., 15.649000000000001`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 203], {
       LineBox[{{957., 16.913999999999998`}, {957., 16.812}}], 
       LineBox[{
        Offset[{1.5, 0}, {957., 16.913999999999998`}], 
         Offset[{-1.5, 0}, {957., 16.913999999999998`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {957., 16.812}], 
         Offset[{-1.5, 0}, {957., 16.812}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 204], {LineBox[{{984., 17.259}, {984., 17.147}}], 
       LineBox[{
        Offset[{1.5, 0}, {984., 17.259}], Offset[{-1.5, 0}, {984., 17.259}]}],
        LineBox[{
        Offset[{1.5, 0}, {984., 17.147}], 
         Offset[{-1.5, 0}, {984., 17.147}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 205], {LineBox[{{986., 17.079}, {986., 15.613}}], 
       LineBox[{
        Offset[{1.5, 0}, {986., 17.079}], Offset[{-1.5, 0}, {986., 17.079}]}],
        LineBox[{
        Offset[{1.5, 0}, {986., 15.613}], 
         Offset[{-1.5, 0}, {986., 15.613}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 206], {
       LineBox[{{986., 4.864}, {986., 4.8500000000000005`}}], 
       LineBox[{
        Offset[{1.5, 0}, {986., 4.864}], Offset[{-1.5, 0}, {986., 4.864}]}], 
       LineBox[{
        Offset[{1.5, 0}, {986., 4.8500000000000005`}], 
         Offset[{-1.5, 0}, {986., 4.8500000000000005`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 207], {LineBox[{{1020., 17.245}, {1020., 17.115}}], 
       LineBox[{
        Offset[{1.5, 0}, {1020., 17.245}], 
         Offset[{-1.5, 0}, {1020., 17.245}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1020., 17.115}], 
         Offset[{-1.5, 0}, {1020., 17.115}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 208], {LineBox[{{1090., 17.223}, {1090., 15.729}}], 
       LineBox[{
        Offset[{1.5, 0}, {1090., 17.223}], 
         Offset[{-1.5, 0}, {1090., 17.223}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1090., 15.729}], 
         Offset[{-1.5, 0}, {1090., 15.729}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 209], {LineBox[{{1091., 4.925}, {1091., 4.873}}], 
       LineBox[{
        Offset[{1.5, 0}, {1091., 4.925}], Offset[{-1.5, 0}, {1091., 4.925}]}],
        LineBox[{
        Offset[{1.5, 0}, {1091., 4.873}], 
         Offset[{-1.5, 0}, {1091., 4.873}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 210], {
       LineBox[{{1140., 16.967}, {1140., 16.884999999999998`}}], 
       LineBox[{
        Offset[{1.5, 0}, {1140., 16.967}], 
         Offset[{-1.5, 0}, {1140., 16.967}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1140., 16.884999999999998`}], 
         Offset[{-1.5, 0}, {1140., 16.884999999999998`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 211], {
       LineBox[{{1161., 17.320999999999998`}, {1161., 15.677}}], 
       LineBox[{
        Offset[{1.5, 0}, {1161., 17.320999999999998`}], 
         Offset[{-1.5, 0}, {1161., 17.320999999999998`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1161., 15.677}], 
         Offset[{-1.5, 0}, {1161., 15.677}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 212], {LineBox[{{1161., 4.882}, {1161., 4.786}}], 
       LineBox[{
        Offset[{1.5, 0}, {1161., 4.882}], Offset[{-1.5, 0}, {1161., 4.882}]}],
        LineBox[{
        Offset[{1.5, 0}, {1161., 4.786}], 
         Offset[{-1.5, 0}, {1161., 4.786}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 213], {LineBox[{{1172., 16.966}, {1172., 16.704}}], 
       LineBox[{
        Offset[{1.5, 0}, {1172., 16.966}], 
         Offset[{-1.5, 0}, {1172., 16.966}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1172., 16.704}], 
         Offset[{-1.5, 0}, {1172., 16.704}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 214], {LineBox[{{1200., 16.781}, {1200., 16.549}}], 
       LineBox[{
        Offset[{1.5, 0}, {1200., 16.781}], 
         Offset[{-1.5, 0}, {1200., 16.781}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1200., 16.549}], 
         Offset[{-1.5, 0}, {1200., 16.549}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 215], {LineBox[{{1232., 16.758}, {1232., 16.69}}], 
       LineBox[{
        Offset[{1.5, 0}, {1232., 16.758}], 
         Offset[{-1.5, 0}, {1232., 16.758}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1232., 16.69}], 
         Offset[{-1.5, 0}, {1232., 16.69}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 216], {LineBox[{{1259., 17.093}, {1259., 16.923}}], 
       LineBox[{
        Offset[{1.5, 0}, {1259., 17.093}], 
         Offset[{-1.5, 0}, {1259., 17.093}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1259., 16.923}], 
         Offset[{-1.5, 0}, {1259., 16.923}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 217], {LineBox[{{1280., 17.049}, {1280., 15.621}}], 
       LineBox[{
        Offset[{1.5, 0}, {1280., 17.049}], 
         Offset[{-1.5, 0}, {1280., 17.049}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1280., 15.621}], 
         Offset[{-1.5, 0}, {1280., 15.621}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 218], {
       LineBox[{{1280., 4.859999999999999}, {1280., 4.82}}], 
       LineBox[{
        Offset[{1.5, 0}, {1280., 4.859999999999999}], 
         Offset[{-1.5, 0}, {1280., 4.859999999999999}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1280., 4.82}], 
         Offset[{-1.5, 0}, {1280., 4.82}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 219], {
       LineBox[{{1294., 17.212}, {1294., 17.029999999999998`}}], 
       LineBox[{
        Offset[{1.5, 0}, {1294., 17.212}], 
         Offset[{-1.5, 0}, {1294., 17.212}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1294., 17.029999999999998`}], 
         Offset[{-1.5, 0}, {1294., 17.029999999999998`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 220], {
       LineBox[{{1354., 17.365}, {1354., 17.083000000000002`}}], 
       LineBox[{
        Offset[{1.5, 0}, {1354., 17.365}], 
         Offset[{-1.5, 0}, {1354., 17.365}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1354., 17.083000000000002`}], 
         Offset[{-1.5, 0}, {1354., 17.083000000000002`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 221], {LineBox[{{1368., 17.885}, {1368., 17.687}}], 
       LineBox[{
        Offset[{1.5, 0}, {1368., 17.885}], 
         Offset[{-1.5, 0}, {1368., 17.885}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1368., 17.687}], 
         Offset[{-1.5, 0}, {1368., 17.687}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 222], {LineBox[{{1393., 4.916}, {1393., 4.872}}], 
       LineBox[{
        Offset[{1.5, 0}, {1393., 4.916}], Offset[{-1.5, 0}, {1393., 4.916}]}],
        LineBox[{
        Offset[{1.5, 0}, {1393., 4.872}], 
         Offset[{-1.5, 0}, {1393., 4.872}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 223], {LineBox[{{1393., 17.014}, {1393., 15.608}}], 
       LineBox[{
        Offset[{1.5, 0}, {1393., 17.014}], 
         Offset[{-1.5, 0}, {1393., 17.014}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1393., 15.608}], 
         Offset[{-1.5, 0}, {1393., 15.608}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 224], {LineBox[{{1415., 17.146}, {1415., 17.11}}], 
       LineBox[{
        Offset[{1.5, 0}, {1415., 17.146}], 
         Offset[{-1.5, 0}, {1415., 17.146}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1415., 17.11}], 
         Offset[{-1.5, 0}, {1415., 17.11}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 225], {
       LineBox[{{1447., 17.364}, {1447., 17.040000000000003`}}], 
       LineBox[{
        Offset[{1.5, 0}, {1447., 17.364}], 
         Offset[{-1.5, 0}, {1447., 17.364}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1447., 17.040000000000003`}], 
         Offset[{-1.5, 0}, {1447., 17.040000000000003`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 226], {LineBox[{{1464., 16.907}, {1464., 15.481}}], 
       LineBox[{
        Offset[{1.5, 0}, {1464., 16.907}], 
         Offset[{-1.5, 0}, {1464., 16.907}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1464., 15.481}], 
         Offset[{-1.5, 0}, {1464., 15.481}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 227], {LineBox[{{1505., 17.02}, {1505., 16.618}}], 
       LineBox[{
        Offset[{1.5, 0}, {1505., 17.02}], Offset[{-1.5, 0}, {1505., 17.02}]}],
        LineBox[{
        Offset[{1.5, 0}, {1505., 16.618}], 
         Offset[{-1.5, 0}, {1505., 16.618}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 228], {
       LineBox[{{1535., 16.684}, {1535., 16.605999999999998`}}], 
       LineBox[{
        Offset[{1.5, 0}, {1535., 16.684}], 
         Offset[{-1.5, 0}, {1535., 16.684}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1535., 16.605999999999998`}], 
         Offset[{-1.5, 0}, {1535., 16.605999999999998`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 229], {LineBox[{{1567., 16.59}, {1567., 16.452}}], 
       LineBox[{
        Offset[{1.5, 0}, {1567., 16.59}], Offset[{-1.5, 0}, {1567., 16.59}]}],
        LineBox[{
        Offset[{1.5, 0}, {1567., 16.452}], 
         Offset[{-1.5, 0}, {1567., 16.452}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 230], {LineBox[{{1577., 16.883}, {1577., 15.647}}], 
       LineBox[{
        Offset[{1.5, 0}, {1577., 16.883}], 
         Offset[{-1.5, 0}, {1577., 16.883}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1577., 15.647}], 
         Offset[{-1.5, 0}, {1577., 15.647}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 231], {
       LineBox[{{1576., 4.822}, {1576., 4.771999999999999}}], 
       LineBox[{
        Offset[{1.5, 0}, {1576., 4.822}], Offset[{-1.5, 0}, {1576., 4.822}]}],
        LineBox[{
        Offset[{1.5, 0}, {1576., 4.771999999999999}], 
         Offset[{-1.5, 0}, {1576., 4.771999999999999}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 232], {
       LineBox[{{1599., 16.927999999999997`}, {1599., 16.604}}], 
       LineBox[{
        Offset[{1.5, 0}, {1599., 16.927999999999997`}], 
         Offset[{-1.5, 0}, {1599., 16.927999999999997`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1599., 16.604}], 
         Offset[{-1.5, 0}, {1599., 16.604}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 233], {LineBox[{{1657., 16.903}, {1657., 16.823}}], 
       LineBox[{
        Offset[{1.5, 0}, {1657., 16.903}], 
         Offset[{-1.5, 0}, {1657., 16.903}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1657., 16.823}], 
         Offset[{-1.5, 0}, {1657., 16.823}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 234], {LineBox[{{1682., 16.775}, {1682., 15.487}}], 
       LineBox[{
        Offset[{1.5, 0}, {1682., 16.775}], 
         Offset[{-1.5, 0}, {1682., 16.775}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1682., 15.487}], 
         Offset[{-1.5, 0}, {1682., 15.487}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 235], {
       LineBox[{{1684., 16.996000000000002`}, {1684., 16.97}}], 
       LineBox[{
        Offset[{1.5, 0}, {1684., 16.996000000000002`}], 
         Offset[{-1.5, 0}, {1684., 16.996000000000002`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1684., 16.97}], 
         Offset[{-1.5, 0}, {1684., 16.97}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 236], {LineBox[{{1689., 16.861}, {1689., 16.779}}], 
       LineBox[{
        Offset[{1.5, 0}, {1689., 16.861}], 
         Offset[{-1.5, 0}, {1689., 16.861}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1689., 16.779}], 
         Offset[{-1.5, 0}, {1689., 16.779}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 237], {
       LineBox[{{1750., 16.814999999999998`}, {1750., 16.719}}], 
       LineBox[{
        Offset[{1.5, 0}, {1750., 16.814999999999998`}], 
         Offset[{-1.5, 0}, {1750., 16.814999999999998`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1750., 16.719}], 
         Offset[{-1.5, 0}, {1750., 16.719}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 238], {
       LineBox[{{1762., 5.237}, {1762., 4.984999999999999}}], 
       LineBox[{
        Offset[{1.5, 0}, {1762., 5.237}], Offset[{-1.5, 0}, {1762., 5.237}]}],
        LineBox[{
        Offset[{1.5, 0}, {1762., 4.984999999999999}], 
         Offset[{-1.5, 0}, {1762., 4.984999999999999}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 239], {
       LineBox[{{1763., 16.991999999999997`}, {1763., 15.319999999999999`}}], 
       LineBox[{
        Offset[{1.5, 0}, {1763., 16.991999999999997`}], 
         Offset[{-1.5, 0}, {1763., 16.991999999999997`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1763., 15.319999999999999`}], 
         Offset[{-1.5, 0}, {1763., 15.319999999999999`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 240], {LineBox[{{1777., 16.783}, {1777., 16.705}}], 
       LineBox[{
        Offset[{1.5, 0}, {1777., 16.783}], 
         Offset[{-1.5, 0}, {1777., 16.783}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1777., 16.705}], 
         Offset[{-1.5, 0}, {1777., 16.705}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 241], {
       LineBox[{{1810., 16.753999999999998`}, {1810., 16.656}}], 
       LineBox[{
        Offset[{1.5, 0}, {1810., 16.753999999999998`}], 
         Offset[{-1.5, 0}, {1810., 16.753999999999998`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1810., 16.656}], 
         Offset[{-1.5, 0}, {1810., 16.656}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 242], {LineBox[{{1819., 16.695}, {1819., 15.143}}], 
       LineBox[{
        Offset[{1.5, 0}, {1819., 16.695}], 
         Offset[{-1.5, 0}, {1819., 16.695}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1819., 15.143}], 
         Offset[{-1.5, 0}, {1819., 15.143}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 243], {LineBox[{{1818., 4.78}, {1818., 4.738}}], 
       LineBox[{
        Offset[{1.5, 0}, {1818., 4.78}], Offset[{-1.5, 0}, {1818., 4.78}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1818., 4.738}], 
         Offset[{-1.5, 0}, {1818., 4.738}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 244], {
       LineBox[{{1841., 17.147000000000002`}, {1841., 16.691}}], 
       LineBox[{
        Offset[{1.5, 0}, {1841., 17.147000000000002`}], 
         Offset[{-1.5, 0}, {1841., 17.147000000000002`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1841., 16.691}], 
         Offset[{-1.5, 0}, {1841., 16.691}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 245], {
       LineBox[{{1934., 16.857}, {1934., 15.302999999999999`}}], 
       LineBox[{
        Offset[{1.5, 0}, {1934., 16.857}], 
         Offset[{-1.5, 0}, {1934., 16.857}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1934., 15.302999999999999`}], 
         Offset[{-1.5, 0}, {1934., 15.302999999999999`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 246], {
       LineBox[{{1933., 4.7700000000000005`}, {1933., 4.726}}], 
       LineBox[{
        Offset[{1.5, 0}, {1933., 4.7700000000000005`}], 
         Offset[{-1.5, 0}, {1933., 4.7700000000000005`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1933., 4.726}], 
         Offset[{-1.5, 0}, {1933., 4.726}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 247], {LineBox[{{1963., 16.622}, {1963., 16.384}}], 
       LineBox[{
        Offset[{1.5, 0}, {1963., 16.622}], 
         Offset[{-1.5, 0}, {1963., 16.622}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1963., 16.384}], 
         Offset[{-1.5, 0}, {1963., 16.384}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 248], {LineBox[{{2017., 16.332}, {2017., 14.76}}], 
       LineBox[{
        Offset[{1.5, 0}, {2017., 16.332}], 
         Offset[{-1.5, 0}, {2017., 16.332}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2017., 14.76}], 
         Offset[{-1.5, 0}, {2017., 14.76}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 249], {
       LineBox[{{2017., 4.694}, {2017., 4.675999999999999}}], 
       LineBox[{
        Offset[{1.5, 0}, {2017., 4.694}], Offset[{-1.5, 0}, {2017., 4.694}]}],
        LineBox[{
        Offset[{1.5, 0}, {2017., 4.675999999999999}], 
         Offset[{-1.5, 0}, {2017., 4.675999999999999}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 250], {LineBox[{{2022., 16.86}, {2022., 16.744}}], 
       LineBox[{
        Offset[{1.5, 0}, {2022., 16.86}], Offset[{-1.5, 0}, {2022., 16.86}]}],
        LineBox[{
        Offset[{1.5, 0}, {2022., 16.744}], 
         Offset[{-1.5, 0}, {2022., 16.744}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 251], {LineBox[{{2053., 16.703}, {2053., 16.627}}], 
       LineBox[{
        Offset[{1.5, 0}, {2053., 16.703}], 
         Offset[{-1.5, 0}, {2053., 16.703}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2053., 16.627}], 
         Offset[{-1.5, 0}, {2053., 16.627}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 252], {LineBox[{{2082., 16.7}, {2082., 16.602}}], 
       LineBox[{
        Offset[{1.5, 0}, {2082., 16.7}], Offset[{-1.5, 0}, {2082., 16.7}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2082., 16.602}], 
         Offset[{-1.5, 0}, {2082., 16.602}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 253], {LineBox[{{2109., 16.663}, {2109., 15.061}}], 
       LineBox[{
        Offset[{1.5, 0}, {2109., 16.663}], 
         Offset[{-1.5, 0}, {2109., 16.663}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2109., 15.061}], 
         Offset[{-1.5, 0}, {2109., 15.061}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 254], {
       LineBox[{{2109., 4.744000000000001}, {2109., 4.716}}], 
       LineBox[{
        Offset[{1.5, 0}, {2109., 4.744000000000001}], 
         Offset[{-1.5, 0}, {2109., 4.744000000000001}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2109., 4.716}], 
         Offset[{-1.5, 0}, {2109., 4.716}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 255], {LineBox[{{2113., 17.165}, {2113., 17.039}}], 
       LineBox[{
        Offset[{1.5, 0}, {2113., 17.165}], 
         Offset[{-1.5, 0}, {2113., 17.165}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2113., 17.039}], 
         Offset[{-1.5, 0}, {2113., 17.039}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 256], {LineBox[{{2144., 16.707}, {2144., 16.545}}], 
       LineBox[{
        Offset[{1.5, 0}, {2144., 16.707}], 
         Offset[{-1.5, 0}, {2144., 16.707}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2144., 16.545}], 
         Offset[{-1.5, 0}, {2144., 16.545}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 257], {
       LineBox[{{2176., 16.718999999999998`}, {2176., 16.495}}], 
       LineBox[{
        Offset[{1.5, 0}, {2176., 16.718999999999998`}], 
         Offset[{-1.5, 0}, {2176., 16.718999999999998`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2176., 16.495}], 
         Offset[{-1.5, 0}, {2176., 16.495}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 258], {
       LineBox[{{2207., 16.807000000000002`}, {2207., 16.713}}], 
       LineBox[{
        Offset[{1.5, 0}, {2207., 16.807000000000002`}], 
         Offset[{-1.5, 0}, {2207., 16.807000000000002`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2207., 16.713}], 
         Offset[{-1.5, 0}, {2207., 16.713}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 259], {
       LineBox[{{2218., 16.860999999999997`}, {2218., 15.252999999999998`}}], 
       LineBox[{
        Offset[{1.5, 0}, {2218., 16.860999999999997`}], 
         Offset[{-1.5, 0}, {2218., 16.860999999999997`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2218., 15.252999999999998`}], 
         Offset[{-1.5, 0}, {2218., 15.252999999999998`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 260], {
       LineBox[{{2218., 4.7459999999999996`}, {2218., 4.738}}], 
       LineBox[{
        Offset[{1.5, 0}, {2218., 4.7459999999999996`}], 
         Offset[{-1.5, 0}, {2218., 4.7459999999999996`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2218., 4.738}], 
         Offset[{-1.5, 0}, {2218., 4.738}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 261], {
       LineBox[{{2235., 16.486}, {2235., 16.331999999999997`}}], 
       LineBox[{
        Offset[{1.5, 0}, {2235., 16.486}], 
         Offset[{-1.5, 0}, {2235., 16.486}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2235., 16.331999999999997`}], 
         Offset[{-1.5, 0}, {2235., 16.331999999999997`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 262], {
       LineBox[{{2293., 16.529}, {2293., 15.216999999999999`}}], 
       LineBox[{
        Offset[{1.5, 0}, {2293., 16.529}], 
         Offset[{-1.5, 0}, {2293., 16.529}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2293., 15.216999999999999`}], 
         Offset[{-1.5, 0}, {2293., 15.216999999999999`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 263], {LineBox[{{2292., 4.731}, {2292., 4.663}}], 
       LineBox[{
        Offset[{1.5, 0}, {2292., 4.731}], Offset[{-1.5, 0}, {2292., 4.731}]}],
        LineBox[{
        Offset[{1.5, 0}, {2292., 4.663}], 
         Offset[{-1.5, 0}, {2292., 4.663}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 264], {LineBox[{{2296., 16.543}, {2296., 16.433}}], 
       LineBox[{
        Offset[{1.5, 0}, {2296., 16.543}], 
         Offset[{-1.5, 0}, {2296., 16.543}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2296., 16.433}], 
         Offset[{-1.5, 0}, {2296., 16.433}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 265], {LineBox[{{2326., 16.866}, {2326., 16.628}}], 
       LineBox[{
        Offset[{1.5, 0}, {2326., 16.866}], 
         Offset[{-1.5, 0}, {2326., 16.866}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2326., 16.628}], 
         Offset[{-1.5, 0}, {2326., 16.628}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 266], {
       LineBox[{{2358., 16.334}, {2358., 16.266000000000002`}}], 
       LineBox[{
        Offset[{1.5, 0}, {2358., 16.334}], 
         Offset[{-1.5, 0}, {2358., 16.334}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2358., 16.266000000000002`}], 
         Offset[{-1.5, 0}, {2358., 16.266000000000002`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 267], {LineBox[{{2388., 16.564}, {2388., 16.484}}], 
       LineBox[{
        Offset[{1.5, 0}, {2388., 16.564}], 
         Offset[{-1.5, 0}, {2388., 16.564}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2388., 16.484}], 
         Offset[{-1.5, 0}, {2388., 16.484}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 268], {
       LineBox[{{2401., 16.25}, {2401., 14.957999999999998`}}], 
       LineBox[{
        Offset[{1.5, 0}, {2401., 16.25}], Offset[{-1.5, 0}, {2401., 16.25}]}],
        LineBox[{
        Offset[{1.5, 0}, {2401., 14.957999999999998`}], 
         Offset[{-1.5, 0}, {2401., 14.957999999999998`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 269], {
       LineBox[{{2449., 16.432}, {2449., 16.272000000000002`}}], 
       LineBox[{
        Offset[{1.5, 0}, {2449., 16.432}], 
         Offset[{-1.5, 0}, {2449., 16.432}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2449., 16.272000000000002`}], 
         Offset[{-1.5, 0}, {2449., 16.272000000000002`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 270], {
       LineBox[{{2481., 16.215999999999998`}, {2481., 16.108}}], 
       LineBox[{
        Offset[{1.5, 0}, {2481., 16.215999999999998`}], 
         Offset[{-1.5, 0}, {2481., 16.215999999999998`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2481., 16.108}], 
         Offset[{-1.5, 0}, {2481., 16.108}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 271], {LineBox[{{2492., 16.469}, {2492., 14.799}}], 
       LineBox[{
        Offset[{1.5, 0}, {2492., 16.469}], 
         Offset[{-1.5, 0}, {2492., 16.469}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2492., 14.799}], 
         Offset[{-1.5, 0}, {2492., 14.799}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 272], {
       LineBox[{{2492., 4.634}, {2492., 4.6080000000000005`}}], 
       LineBox[{
        Offset[{1.5, 0}, {2492., 4.634}], Offset[{-1.5, 0}, {2492., 4.634}]}],
        LineBox[{
        Offset[{1.5, 0}, {2492., 4.6080000000000005`}], 
         Offset[{-1.5, 0}, {2492., 4.6080000000000005`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 273], {
       LineBox[{{2510., 16.256999999999998`}, {2510., 16.113}}], 
       LineBox[{
        Offset[{1.5, 0}, {2510., 16.256999999999998`}], 
         Offset[{-1.5, 0}, {2510., 16.256999999999998`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2510., 16.113}], 
         Offset[{-1.5, 0}, {2510., 16.113}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 274], {
       LineBox[{{2542., 16.599}, {2542., 16.333000000000002`}}], 
       LineBox[{
        Offset[{1.5, 0}, {2542., 16.599}], 
         Offset[{-1.5, 0}, {2542., 16.599}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2542., 16.333000000000002`}], 
         Offset[{-1.5, 0}, {2542., 16.333000000000002`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 275], {LineBox[{{2574., 16.125}, {2574., 16.031}}], 
       LineBox[{
        Offset[{1.5, 0}, {2574., 16.125}], 
         Offset[{-1.5, 0}, {2574., 16.125}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2574., 16.031}], 
         Offset[{-1.5, 0}, {2574., 16.031}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 276], {
       LineBox[{{2583., 16.432000000000002`}, {2583., 14.860000000000001`}}], 
       LineBox[{
        Offset[{1.5, 0}, {2583., 16.432000000000002`}], 
         Offset[{-1.5, 0}, {2583., 16.432000000000002`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2583., 14.860000000000001`}], 
         Offset[{-1.5, 0}, {2583., 14.860000000000001`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 277], {
       LineBox[{{2582., 4.659}, {2582., 4.6290000000000004`}}], 
       LineBox[{
        Offset[{1.5, 0}, {2582., 4.659}], Offset[{-1.5, 0}, {2582., 4.659}]}],
        LineBox[{
        Offset[{1.5, 0}, {2582., 4.6290000000000004`}], 
         Offset[{-1.5, 0}, {2582., 4.6290000000000004`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 278], {
       LineBox[{{2601., 16.343999999999998`}, {2601., 16.258}}], 
       LineBox[{
        Offset[{1.5, 0}, {2601., 16.343999999999998`}], 
         Offset[{-1.5, 0}, {2601., 16.343999999999998`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2601., 16.258}], 
         Offset[{-1.5, 0}, {2601., 16.258}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 279], {LineBox[{{2632., 15.858}, {2632., 15.782}}], 
       LineBox[{
        Offset[{1.5, 0}, {2632., 15.858}], 
         Offset[{-1.5, 0}, {2632., 15.858}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2632., 15.782}], 
         Offset[{-1.5, 0}, {2632., 15.782}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 280], {
       LineBox[{{2662., 15.984}, {2662., 15.953999999999999`}}], 
       LineBox[{
        Offset[{1.5, 0}, {2662., 15.984}], 
         Offset[{-1.5, 0}, {2662., 15.984}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2662., 15.953999999999999`}], 
         Offset[{-1.5, 0}, {2662., 15.953999999999999`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 281], {LineBox[{{2675., 16.192}, {2675., 15.012}}], 
       LineBox[{
        Offset[{1.5, 0}, {2675., 16.192}], 
         Offset[{-1.5, 0}, {2675., 16.192}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2675., 15.012}], 
         Offset[{-1.5, 0}, {2675., 15.012}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 282], {
       LineBox[{{2674., 4.606999999999999}, {2674., 4.577}}], 
       LineBox[{
        Offset[{1.5, 0}, {2674., 4.606999999999999}], 
         Offset[{-1.5, 0}, {2674., 4.606999999999999}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2674., 4.577}], 
         Offset[{-1.5, 0}, {2674., 4.577}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 283], {LineBox[{{2755., 16.162}, {2755., 16.082}}], 
       LineBox[{
        Offset[{1.5, 0}, {2755., 16.162}], 
         Offset[{-1.5, 0}, {2755., 16.162}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2755., 16.082}], 
         Offset[{-1.5, 0}, {2755., 16.082}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 284], {LineBox[{{2761., 15.853}, {2761., 14.539}}], 
       LineBox[{
        Offset[{1.5, 0}, {2761., 15.853}], 
         Offset[{-1.5, 0}, {2761., 15.853}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2761., 14.539}], 
         Offset[{-1.5, 0}, {2761., 14.539}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 285], {
       LineBox[{{2761., 4.588}, {2761., 4.5680000000000005`}}], 
       LineBox[{
        Offset[{1.5, 0}, {2761., 4.588}], Offset[{-1.5, 0}, {2761., 4.588}]}],
        LineBox[{
        Offset[{1.5, 0}, {2761., 4.5680000000000005`}], 
         Offset[{-1.5, 0}, {2761., 4.5680000000000005`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 286], {LineBox[{{2814., 16.058}, {2814., 15.922}}], 
       LineBox[{
        Offset[{1.5, 0}, {2814., 16.058}], 
         Offset[{-1.5, 0}, {2814., 16.058}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2814., 15.922}], 
         Offset[{-1.5, 0}, {2814., 15.922}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 287], {
       LineBox[{{2838., 4.598000000000001}, {2838., 4.564}}], 
       LineBox[{
        Offset[{1.5, 0}, {2838., 4.598000000000001}], 
         Offset[{-1.5, 0}, {2838., 4.598000000000001}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2838., 4.564}], 
         Offset[{-1.5, 0}, {2838., 4.564}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 288], {LineBox[{{2838., 16.161}, {2838., 14.819}}], 
       LineBox[{
        Offset[{1.5, 0}, {2838., 16.161}], 
         Offset[{-1.5, 0}, {2838., 16.161}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2838., 14.819}], 
         Offset[{-1.5, 0}, {2838., 14.819}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 289], {
       LineBox[{{2848., 16.311}, {2848., 16.185000000000002`}}], 
       LineBox[{
        Offset[{1.5, 0}, {2848., 16.311}], 
         Offset[{-1.5, 0}, {2848., 16.311}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2848., 16.185000000000002`}], 
         Offset[{-1.5, 0}, {2848., 16.185000000000002`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 290], {
       LineBox[{{2875., 16.311}, {2875., 16.185000000000002`}}], 
       LineBox[{
        Offset[{1.5, 0}, {2875., 16.311}], 
         Offset[{-1.5, 0}, {2875., 16.311}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2875., 16.185000000000002`}], 
         Offset[{-1.5, 0}, {2875., 16.185000000000002`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 291], {LineBox[{{2938., 17.207}, {2938., 17.003}}], 
       LineBox[{
        Offset[{1.5, 0}, {2938., 17.207}], 
         Offset[{-1.5, 0}, {2938., 17.207}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2938., 17.003}], 
         Offset[{-1.5, 0}, {2938., 17.003}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 292], {LineBox[{{2941., 17.165}, {2941., 15.569}}], 
       LineBox[{
        Offset[{1.5, 0}, {2941., 17.165}], 
         Offset[{-1.5, 0}, {2941., 17.165}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2941., 15.569}], 
         Offset[{-1.5, 0}, {2941., 15.569}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 293], {LineBox[{{2940., 4.847}, {2940., 4.831}}], 
       LineBox[{
        Offset[{1.5, 0}, {2940., 4.847}], Offset[{-1.5, 0}, {2940., 4.847}]}],
        LineBox[{
        Offset[{1.5, 0}, {2940., 4.831}], 
         Offset[{-1.5, 0}, {2940., 4.831}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 294], {
       LineBox[{{2966., 17.07}, {2966., 16.933999999999997`}}], 
       LineBox[{
        Offset[{1.5, 0}, {2966., 17.07}], Offset[{-1.5, 0}, {2966., 17.07}]}],
        LineBox[{
        Offset[{1.5, 0}, {2966., 16.933999999999997`}], 
         Offset[{-1.5, 0}, {2966., 16.933999999999997`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 295], {LineBox[{{2997., 16.938}, {2997., 16.702}}], 
       LineBox[{
        Offset[{1.5, 0}, {2997., 16.938}], 
         Offset[{-1.5, 0}, {2997., 16.938}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2997., 16.702}], 
         Offset[{-1.5, 0}, {2997., 16.702}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 296], {LineBox[{{3025., 16.977}, {3025., 16.873}}], 
       LineBox[{
        Offset[{1.5, 0}, {3025., 16.977}], 
         Offset[{-1.5, 0}, {3025., 16.977}]}], 
       LineBox[{
        Offset[{1.5, 0}, {3025., 16.873}], 
         Offset[{-1.5, 0}, {3025., 16.873}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 297], {
       LineBox[{{3043., 17.180999999999997`}, {3043., 15.694999999999999`}}], 
       LineBox[{
        Offset[{1.5, 0}, {3043., 17.180999999999997`}], 
         Offset[{-1.5, 0}, {3043., 17.180999999999997`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {3043., 15.694999999999999`}], 
         Offset[{-1.5, 0}, {3043., 15.694999999999999`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 298], {LineBox[{{3043., 4.523}, {3043., 4.199}}], 
       LineBox[{
        Offset[{1.5, 0}, {3043., 4.523}], Offset[{-1.5, 0}, {3043., 4.523}]}],
        LineBox[{
        Offset[{1.5, 0}, {3043., 4.199}], 
         Offset[{-1.5, 0}, {3043., 4.199}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 299], {LineBox[{{3063., 16.944}, {3063., 16.798}}], 
       LineBox[{
        Offset[{1.5, 0}, {3063., 16.944}], 
         Offset[{-1.5, 0}, {3063., 16.944}]}], 
       LineBox[{
        Offset[{1.5, 0}, {3063., 16.798}], 
         Offset[{-1.5, 0}, {3063., 16.798}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 300], {LineBox[{{3090., 16.925}, {3090., 16.803}}], 
       LineBox[{
        Offset[{1.5, 0}, {3090., 16.925}], 
         Offset[{-1.5, 0}, {3090., 16.925}]}], 
       LineBox[{
        Offset[{1.5, 0}, {3090., 16.803}], 
         Offset[{-1.5, 0}, {3090., 16.803}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 301], {
       LineBox[{{3139., 16.951}, {3139., 15.499000000000002`}}], 
       LineBox[{
        Offset[{1.5, 0}, {3139., 16.951}], 
         Offset[{-1.5, 0}, {3139., 16.951}]}], 
       LineBox[{
        Offset[{1.5, 0}, {3139., 15.499000000000002`}], 
         Offset[{-1.5, 0}, {3139., 15.499000000000002`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 302], {
       LineBox[{{3139., 4.869000000000001}, {3139., 4.803}}], 
       LineBox[{
        Offset[{1.5, 0}, {3139., 4.869000000000001}], 
         Offset[{-1.5, 0}, {3139., 4.869000000000001}]}], 
       LineBox[{
        Offset[{1.5, 0}, {3139., 4.803}], 
         Offset[{-1.5, 0}, {3139., 4.803}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 303], {LineBox[{{3151., 17.077}, {3151., 16.937}}], 
       LineBox[{
        Offset[{1.5, 0}, {3151., 17.077}], 
         Offset[{-1.5, 0}, {3151., 17.077}]}], 
       LineBox[{
        Offset[{1.5, 0}, {3151., 16.937}], 
         Offset[{-1.5, 0}, {3151., 16.937}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 304], {
       LineBox[{{3182., 17.083}, {3182., 16.948999999999998`}}], 
       LineBox[{
        Offset[{1.5, 0}, {3182., 17.083}], 
         Offset[{-1.5, 0}, {3182., 17.083}]}], 
       LineBox[{
        Offset[{1.5, 0}, {3182., 16.948999999999998`}], 
         Offset[{-1.5, 0}, {3182., 16.948999999999998`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 305], {LineBox[{{3209., 17.356}, {3209., 15.756}}], 
       LineBox[{
        Offset[{1.5, 0}, {3209., 17.356}], 
         Offset[{-1.5, 0}, {3209., 17.356}]}], 
       LineBox[{
        Offset[{1.5, 0}, {3209., 15.756}], 
         Offset[{-1.5, 0}, {3209., 15.756}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 306], {
       LineBox[{{3214., 17.090999999999998`}, {3214., 16.925}}], 
       LineBox[{
        Offset[{1.5, 0}, {3214., 17.090999999999998`}], 
         Offset[{-1.5, 0}, {3214., 17.090999999999998`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {3214., 16.925}], 
         Offset[{-1.5, 0}, {3214., 16.925}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 307], {
       LineBox[{{3243., 17.024}, {3243., 16.823999999999998`}}], 
       LineBox[{
        Offset[{1.5, 0}, {3243., 17.024}], 
         Offset[{-1.5, 0}, {3243., 17.024}]}], 
       LineBox[{
        Offset[{1.5, 0}, {3243., 16.823999999999998`}], 
         Offset[{-1.5, 0}, {3243., 16.823999999999998`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 308], {
       LineBox[{{3274., 16.982}, {3274., 16.875999999999998`}}], 
       LineBox[{
        Offset[{1.5, 0}, {3274., 16.982}], 
         Offset[{-1.5, 0}, {3274., 16.982}]}], 
       LineBox[{
        Offset[{1.5, 0}, {3274., 16.875999999999998`}], 
         Offset[{-1.5, 0}, {3274., 16.875999999999998`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 309], {LineBox[{{3304., 17.155}, {3304., 17.019}}], 
       LineBox[{
        Offset[{1.5, 0}, {3304., 17.155}], 
         Offset[{-1.5, 0}, {3304., 17.155}]}], 
       LineBox[{
        Offset[{1.5, 0}, {3304., 17.019}], 
         Offset[{-1.5, 0}, {3304., 17.019}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 310], {
       LineBox[{{3314., 17.931}, {3314., 15.153000000000002`}}], 
       LineBox[{
        Offset[{1.5, 0}, {3314., 17.931}], 
         Offset[{-1.5, 0}, {3314., 17.931}]}], 
       LineBox[{
        Offset[{1.5, 0}, {3314., 15.153000000000002`}], 
         Offset[{-1.5, 0}, {3314., 15.153000000000002`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 311], {LineBox[{{3331., 16.908}, {3331., 16.728}}], 
       LineBox[{
        Offset[{1.5, 0}, {3331., 16.908}], 
         Offset[{-1.5, 0}, {3331., 16.908}]}], 
       LineBox[{
        Offset[{1.5, 0}, {3331., 16.728}], 
         Offset[{-1.5, 0}, {3331., 16.728}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 312], {LineBox[{{3362., 16.784}, {3362., 16.61}}], 
       LineBox[{
        Offset[{1.5, 0}, {3362., 16.784}], 
         Offset[{-1.5, 0}, {3362., 16.784}]}], 
       LineBox[{
        Offset[{1.5, 0}, {3362., 16.61}], 
         Offset[{-1.5, 0}, {3362., 16.61}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 313], {
       LineBox[{{3390., 16.901999999999997`}, {3390., 16.776}}], 
       LineBox[{
        Offset[{1.5, 0}, {3390., 16.901999999999997`}], 
         Offset[{-1.5, 0}, {3390., 16.901999999999997`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {3390., 16.776}], 
         Offset[{-1.5, 0}, {3390., 16.776}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 314], {LineBox[{{3454., 16.993}, {3454., 16.895}}], 
       LineBox[{
        Offset[{1.5, 0}, {3454., 16.993}], 
         Offset[{-1.5, 0}, {3454., 16.993}]}], 
       LineBox[{
        Offset[{1.5, 0}, {3454., 16.895}], 
         Offset[{-1.5, 0}, {3454., 16.895}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 315], {
       LineBox[{{3510., 16.735}, {3510., 15.469000000000001`}}], 
       LineBox[{
        Offset[{1.5, 0}, {3510., 16.735}], 
         Offset[{-1.5, 0}, {3510., 16.735}]}], 
       LineBox[{
        Offset[{1.5, 0}, {3510., 15.469000000000001`}], 
         Offset[{-1.5, 0}, {3510., 15.469000000000001`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 316], {
       LineBox[{{3510., 4.837}, {3510., 4.7989999999999995`}}], 
       LineBox[{
        Offset[{1.5, 0}, {3510., 4.837}], Offset[{-1.5, 0}, {3510., 4.837}]}],
        LineBox[{
        Offset[{1.5, 0}, {3510., 4.7989999999999995`}], 
         Offset[{-1.5, 0}, {3510., 4.7989999999999995`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 317], {LineBox[{{3517., 17.007}, {3517., 16.935}}], 
       LineBox[{
        Offset[{1.5, 0}, {3517., 17.007}], 
         Offset[{-1.5, 0}, {3517., 17.007}]}], 
       LineBox[{
        Offset[{1.5, 0}, {3517., 16.935}], 
         Offset[{-1.5, 0}, {3517., 16.935}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 318], {LineBox[{{3577., 17.232}, {3577., 17.088}}], 
       LineBox[{
        Offset[{1.5, 0}, {3577., 17.232}], 
         Offset[{-1.5, 0}, {3577., 17.232}]}], 
       LineBox[{
        Offset[{1.5, 0}, {3577., 17.088}], 
         Offset[{-1.5, 0}, {3577., 17.088}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 319], {
       LineBox[{{3594., 4.882000000000001}, {3594., 4.848}}], 
       LineBox[{
        Offset[{1.5, 0}, {3594., 4.882000000000001}], 
         Offset[{-1.5, 0}, {3594., 4.882000000000001}]}], 
       LineBox[{
        Offset[{1.5, 0}, {3594., 4.848}], 
         Offset[{-1.5, 0}, {3594., 4.848}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 320], {
       LineBox[{{3596., 17.189}, {3596., 15.645000000000001`}}], 
       LineBox[{
        Offset[{1.5, 0}, {3596., 17.189}], 
         Offset[{-1.5, 0}, {3596., 17.189}]}], 
       LineBox[{
        Offset[{1.5, 0}, {3596., 15.645000000000001`}], 
         Offset[{-1.5, 0}, {3596., 15.645000000000001`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 321], {
       LineBox[{{3606., 17.644}, {3606., 17.451999999999998`}}], 
       LineBox[{
        Offset[{1.5, 0}, {3606., 17.644}], 
         Offset[{-1.5, 0}, {3606., 17.644}]}], 
       LineBox[{
        Offset[{1.5, 0}, {3606., 17.451999999999998`}], 
         Offset[{-1.5, 0}, {3606., 17.451999999999998`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 322], {
       LineBox[{{3637., 17.395}, {3637., 17.269000000000002`}}], 
       LineBox[{
        Offset[{1.5, 0}, {3637., 17.395}], 
         Offset[{-1.5, 0}, {3637., 17.395}]}], 
       LineBox[{
        Offset[{1.5, 0}, {3637., 17.269000000000002`}], 
         Offset[{-1.5, 0}, {3637., 17.269000000000002`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 323], {LineBox[{{3668., 17.136}, {3668., 16.968}}], 
       LineBox[{
        Offset[{1.5, 0}, {3668., 17.136}], 
         Offset[{-1.5, 0}, {3668., 17.136}]}], 
       LineBox[{
        Offset[{1.5, 0}, {3668., 16.968}], 
         Offset[{-1.5, 0}, {3668., 16.968}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 324], {LineBox[{{3694., 16.975}, {3694., 15.381}}], 
       LineBox[{
        Offset[{1.5, 0}, {3694., 16.975}], 
         Offset[{-1.5, 0}, {3694., 16.975}]}], 
       LineBox[{
        Offset[{1.5, 0}, {3694., 15.381}], 
         Offset[{-1.5, 0}, {3694., 15.381}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 325], {LineBox[{{3693., 4.856}, {3693., 4.836}}], 
       LineBox[{
        Offset[{1.5, 0}, {3693., 4.856}], Offset[{-1.5, 0}, {3693., 4.856}]}],
        LineBox[{
        Offset[{1.5, 0}, {3693., 4.836}], 
         Offset[{-1.5, 0}, {3693., 4.836}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 326], {
       LineBox[{{3695., 16.959}, {3695., 16.781000000000002`}}], 
       LineBox[{
        Offset[{1.5, 0}, {3695., 16.959}], 
         Offset[{-1.5, 0}, {3695., 16.959}]}], 
       LineBox[{
        Offset[{1.5, 0}, {3695., 16.781000000000002`}], 
         Offset[{-1.5, 0}, {3695., 16.781000000000002`}]}]}}}, {}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  Frame->True,
  FrameLabel->{{
     FormBox["\"Coeff. calibration Est (Jy)\"", TraditionalForm], 
     FormBox["\"\"", TraditionalForm]}, {
     FormBox["\"Jour depuis 31 Jan. 2001\"", TraditionalForm], 
     FormBox["\"1410 MHz\"", TraditionalForm]}},
  GridLines->Automatic,
  ImageSize->{878., Automatic},
  LabelStyle->Directive[
    RGBColor[0, 0, 1], Large],
  PlotRange->{All, {0, 25}},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.5104799163861666`*^9, 3.510480505531827*^9, 3.5104805873230057`*^9, {
   3.510480694543727*^9, 3.510480776938965*^9}, 3.51048081199047*^9, {
   3.510480910706341*^9, 3.5104809333646064`*^9}, {3.5104809742006893`*^9, 
   3.510480991828452*^9}, {3.5104811317154393`*^9, 3.510481154182686*^9}, 
   3.510481218892156*^9, 3.510481521739438*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"calO", "=", 
   RowBox[{"Import", "[", 
    RowBox[{"\"\<calib1410MhzOuest.txt\>\"", ",", "\"\<Table\>\""}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.5104810185721264`*^9, 3.5104810264079094`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"calib1410O", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"DaysBetween", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"2001", ",", "1", ",", "31"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Quotient", "[", 
              RowBox[{
               RowBox[{"calO", "[", 
                RowBox[{"[", 
                 RowBox[{"n", ",", "1"}], "]"}], "]"}], ",", "10000"}], "]"}],
              ",", 
             RowBox[{"Quotient", "[", 
              RowBox[{
               RowBox[{"Mod", "[", 
                RowBox[{
                 RowBox[{"calO", "[", 
                  RowBox[{"[", 
                   RowBox[{"n", ",", "1"}], "]"}], "]"}], ",", "10000"}], 
                "]"}], ",", "100"}], "]"}], ",", 
             RowBox[{"Mod", "[", 
              RowBox[{
               RowBox[{"Mod", "[", 
                RowBox[{
                 RowBox[{"calO", "[", 
                  RowBox[{"[", 
                   RowBox[{"n", ",", "1"}], "]"}], "]"}], ",", "10000"}], 
                "]"}], ",", "100"}], "]"}]}], "}"}]}], "]"}], ",", 
         RowBox[{"calO", "[", 
          RowBox[{"[", 
           RowBox[{"n", ",", "4"}], "]"}], "]"}]}], "}"}], ",", 
       RowBox[{"ErrorBar", "[", 
        RowBox[{"calO", "[", 
         RowBox[{"[", 
          RowBox[{"n", ",", "5"}], "]"}], "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "1", ",", 
       RowBox[{"Length", "[", "calO", "]"}]}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.510481042570526*^9, 3.510481095069775*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ErrorListPlot", "[", 
  RowBox[{"calib1410O", ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"All", ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "25"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"PlotMarkers", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"LabelStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Blue", ",", "Large"}], "]"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<Coeff. calibration Ouest (Jy)\>\"", ",", "\"\<\>\""}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<Jour depuis 31 Jan. 2001\>\"", ",", "\"\<1410 MHz\>\""}], 
       "}"}]}], "}"}]}], ",", 
   RowBox[{"GridLines", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.510481088435112*^9, 3.5104811480990777`*^9}, 
   3.5104815171979837`*^9}],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJztlv9P1HUcx4kcOiLHTNEMSx0zlqTjDtNm6avkm6aEX2KMjG7sLOZICAP5
VqAoxBD5fpxwHnfcwd3B5Vwx56w5ZJdzzS/MbGZi2UTMvihYTjNqfd6f1/P9
oetvuM8vt8e9Xu/3+/X9/V6QlbtpW3BQUFDiI0FB4ld+rxpuDC18Sk9MMfRg
8/XuDqMOnEDZjb+VrS6IY6bNtPRqVMjub6A/kEFjrlOvLa+B/JqBTnTOXXp1
ROobafsXHzTP8Um5kZx5L4deqtRrfCRfnDCb2ZBDyum++WM435BLXQlHf/+7
X9qXT5ccygbLwUM7KWR365ra/VK/gLbWD96LLpvkm395xi+cnQV7C6g2R/nn
fWn/Lpr+/KeH7kwFVxRTSlZ4+osXJZeSQv2nC8HhZXTyK3vC0ScmeV1Y8OLq
iAjof0hiO1cV5HnldPaM8v0Kjq6gzONrw4Ifm+SdaoCx3lxBQry4GvKG3bR+
ec0rhi/BH++hZ2OneSNLwNmVHL+XwEWVlKY6BH/z9pJI75ViyFOrSJy27CPw
WBUtEwYN6jSuHBAOYn1yNcfvceg/qKYM48ofXq8DT6vh+rgn66WWUuvadsyQ
+bXVkpJtR95bkP9URyK8/dEy/gdotTBgv8znAdY/pNO4+Nai2GkxiM+1ehLl
NMUkz2/k+vNAP6yRDif9WDJzCfSHGmmLKCiCflQTKavTpn+i03iXWrDwN7WJ
FOfaduikfU2kpvdP6FMz85OQe5tJVMeJt2V9ttD5+0oDfa7TWI3Ho7BnRYt/
fKJbqTri8rn7n4ENrVQuGqYI/eJrJesd4WCExqo/A9g/0kQW3/wj+W6st5jo
mX2/bDxmlf1l4vrZB/29bdzfUZBPtJFZsWYgFFxmJtE+W+9A32mmeSLh58E2
M/fjRcRrwkxKNSoaWD9ykApEgFPAye2oZ6xPbed+kf1kbOf+SwKnd9BMkcA4
We8dWI/5sL+DlGhtvi798XWw/c/J8yycz3ngHAvHMx362Rauj8Ow32fh+WSE
/gor1+dp6MdZUS/Q91p5vkzIeHbyPJo9yX765k6u7/XYP9TG/TsXHG+jUuGw
5BIbxYsBtVansepvN/bbY6OvNygWHpT1aeP60cv6s5PfPF9l53n9BniLneu1
XKexOg/HsX+hneMxAvnPdj4/QfavneujHvpjdp53Idg/potEud1IlfHv4vlz
GevdXSSin7QA8sEuvi+mQL7Qwf1zBZzlYP+awUUOsinqUaOxGuvVD/ZYHNQ7
fmFDVgP0hx0kzBkKxnmRTuY9kC9x+ucvxkmxakFjv01Orp9vIW9wkrhuct4F
n3Fy/ZeCR52ULBycCh5x8rzNxH5V3TRFDOirkDd1013F3HBzrMZ+8Z3o5no9
J+3roXfUb5bGt8X2D7Geevi+MmF+FP6P/+hhe98EP+zBfSnnew/mJ/otxkVi
2relQH+7i0yK+zdXgrtcHK948CkX3weteo3V+bMN9t52sX9LoR/l5visAle5
uR8y9BrPUC8k2GN183zLhP6wm+ehATzD439fRnr4/s2BPM3D8+cFcIuH/rlY
dGvRRvCQh94T7ZAPHvGQaJfO49gvpJcSxfhLhzy+l/2PApf1kmi31jXgiV5+
70jO6WN7K/Qaq+kcxXwv6YO/0L/bx/HKBc/0kvocWYV4zPFSrlhwUvafl/N1
W+bLy/enF+z2+ud/2Mv92oD133np2NNKgFdg/++9bF8i9IMC78XAezHwXgy8
FwPvRc5P4L0YeC8G3ouB92Lgvajyf96L/wKdt+gQ
   "], {
    {Hue[0.67, 0.6, 0.6], {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 164], {
       LineBox[{{0., 19.839000000000002`}, {0., 18.373}}], 
       LineBox[{
        Offset[{1.5, 0}, {0., 19.839000000000002`}], 
         Offset[{-1.5, 0}, {0., 19.839000000000002`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {0., 18.373}], Offset[{-1.5, 0}, {0., 18.373}]}]}}, {
      InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 165], {
       LineBox[{{14., 18.505}, {14., 18.281000000000002`}}], 
       LineBox[{
        Offset[{1.5, 0}, {14., 18.505}], Offset[{-1.5, 0}, {14., 18.505}]}], 
       LineBox[{
        Offset[{1.5, 0}, {14., 18.281000000000002`}], 
         Offset[{-1.5, 0}, {14., 18.281000000000002`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 166], {
       LineBox[{{42., 20.709999999999997`}, {42., 20.206}}], 
       LineBox[{
        Offset[{1.5, 0}, {42., 20.709999999999997`}], 
         Offset[{-1.5, 0}, {42., 20.709999999999997`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {42., 20.206}], 
         Offset[{-1.5, 0}, {42., 20.206}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 167], {LineBox[{{77., 20.108}, {77., 19.56}}], 
       LineBox[{
        Offset[{1.5, 0}, {77., 20.108}], Offset[{-1.5, 0}, {77., 20.108}]}], 
       LineBox[{
        Offset[{1.5, 0}, {77., 19.56}], Offset[{-1.5, 0}, {77., 19.56}]}]}}, {
      InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 168], {
       LineBox[{{107., 20.738000000000003`}, {107., 20.334}}], 
       LineBox[{
        Offset[{1.5, 0}, {107., 20.738000000000003`}], 
         Offset[{-1.5, 0}, {107., 20.738000000000003`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {107., 20.334}], 
         Offset[{-1.5, 0}, {107., 20.334}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 169], {
       LineBox[{{135., 20.933}, {135., 20.854999999999997`}}], 
       LineBox[{
        Offset[{1.5, 0}, {135., 20.933}], Offset[{-1.5, 0}, {135., 20.933}]}],
        LineBox[{
        Offset[{1.5, 0}, {135., 20.854999999999997`}], 
         Offset[{-1.5, 0}, {135., 20.854999999999997`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 170], {
       LineBox[{{162., 20.892}, {162., 20.639999999999997`}}], 
       LineBox[{
        Offset[{1.5, 0}, {162., 20.892}], Offset[{-1.5, 0}, {162., 20.892}]}],
        LineBox[{
        Offset[{1.5, 0}, {162., 20.639999999999997`}], 
         Offset[{-1.5, 0}, {162., 20.639999999999997`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 171], {LineBox[{{167., 20.611}, {167., 18.419}}], 
       LineBox[{
        Offset[{1.5, 0}, {167., 20.611}], Offset[{-1.5, 0}, {167., 20.611}]}],
        LineBox[{
        Offset[{1.5, 0}, {167., 18.419}], 
         Offset[{-1.5, 0}, {167., 18.419}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 172], {
       LineBox[{{167., 5.9559999999999995`}, {167., 5.788}}], 
       LineBox[{
        Offset[{1.5, 0}, {167., 5.9559999999999995`}], 
         Offset[{-1.5, 0}, {167., 5.9559999999999995`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {167., 5.788}], 
         Offset[{-1.5, 0}, {167., 5.788}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 173], {LineBox[{{227., 19.671}, {227., 18.205}}], 
       LineBox[{
        Offset[{1.5, 0}, {227., 19.671}], Offset[{-1.5, 0}, {227., 19.671}]}],
        LineBox[{
        Offset[{1.5, 0}, {227., 18.205}], 
         Offset[{-1.5, 0}, {227., 18.205}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 174], {LineBox[{{251., 19.82}, {251., 19.594}}], 
       LineBox[{
        Offset[{1.5, 0}, {251., 19.82}], Offset[{-1.5, 0}, {251., 19.82}]}], 
       LineBox[{
        Offset[{1.5, 0}, {251., 19.594}], 
         Offset[{-1.5, 0}, {251., 19.594}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 175], {LineBox[{{288., 19.253}, {288., 19.177}}], 
       LineBox[{
        Offset[{1.5, 0}, {288., 19.253}], Offset[{-1.5, 0}, {288., 19.253}]}],
        LineBox[{
        Offset[{1.5, 0}, {288., 19.177}], 
         Offset[{-1.5, 0}, {288., 19.177}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 176], {LineBox[{{317., 18.732}, {317., 18.366}}], 
       LineBox[{
        Offset[{1.5, 0}, {317., 18.732}], Offset[{-1.5, 0}, {317., 18.732}]}],
        LineBox[{
        Offset[{1.5, 0}, {317., 18.366}], 
         Offset[{-1.5, 0}, {317., 18.366}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 177], {LineBox[{{342., 19.176}, {342., 17.794}}], 
       LineBox[{
        Offset[{1.5, 0}, {342., 19.176}], Offset[{-1.5, 0}, {342., 19.176}]}],
        LineBox[{
        Offset[{1.5, 0}, {342., 17.794}], 
         Offset[{-1.5, 0}, {342., 17.794}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 178], {
       LineBox[{{342., 5.529999999999999}, {342., 5.372}}], 
       LineBox[{
        Offset[{1.5, 0}, {342., 5.529999999999999}], 
         Offset[{-1.5, 0}, {342., 5.529999999999999}]}], 
       LineBox[{
        Offset[{1.5, 0}, {342., 5.372}], 
         Offset[{-1.5, 0}, {342., 5.372}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 179], {LineBox[{{348., 19.552}, {348., 19.336}}], 
       LineBox[{
        Offset[{1.5, 0}, {348., 19.552}], Offset[{-1.5, 0}, {348., 19.552}]}],
        LineBox[{
        Offset[{1.5, 0}, {348., 19.336}], 
         Offset[{-1.5, 0}, {348., 19.336}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 180], {
       LineBox[{{380., 19.227}, {380., 18.834999999999997`}}], 
       LineBox[{
        Offset[{1.5, 0}, {380., 19.227}], Offset[{-1.5, 0}, {380., 19.227}]}],
        LineBox[{
        Offset[{1.5, 0}, {380., 18.834999999999997`}], 
         Offset[{-1.5, 0}, {380., 18.834999999999997`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 181], {
       LineBox[{{408., 20.011}, {408., 19.647000000000002`}}], 
       LineBox[{
        Offset[{1.5, 0}, {408., 20.011}], Offset[{-1.5, 0}, {408., 20.011}]}],
        LineBox[{
        Offset[{1.5, 0}, {408., 19.647000000000002`}], 
         Offset[{-1.5, 0}, {408., 19.647000000000002`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 182], {
       LineBox[{{440., 19.575}, {440., 19.352999999999998`}}], 
       LineBox[{
        Offset[{1.5, 0}, {440., 19.575}], Offset[{-1.5, 0}, {440., 19.575}]}],
        LineBox[{
        Offset[{1.5, 0}, {440., 19.352999999999998`}], 
         Offset[{-1.5, 0}, {440., 19.352999999999998`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 183], {
       LineBox[{{449., 19.937}, {449., 18.217000000000002`}}], 
       LineBox[{
        Offset[{1.5, 0}, {449., 19.937}], Offset[{-1.5, 0}, {449., 19.937}]}],
        LineBox[{
        Offset[{1.5, 0}, {449., 18.217000000000002`}], 
         Offset[{-1.5, 0}, {449., 18.217000000000002`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 184], {LineBox[{{449., 5.589}, {449., 5.455}}], 
       LineBox[{
        Offset[{1.5, 0}, {449., 5.589}], Offset[{-1.5, 0}, {449., 5.589}]}], 
       LineBox[{
        Offset[{1.5, 0}, {449., 5.455}], 
         Offset[{-1.5, 0}, {449., 5.455}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 185], {
       LineBox[{{472., 19.544999999999998`}, {472., 19.507}}], 
       LineBox[{
        Offset[{1.5, 0}, {472., 19.544999999999998`}], 
         Offset[{-1.5, 0}, {472., 19.544999999999998`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {472., 19.507}], 
         Offset[{-1.5, 0}, {472., 19.507}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 186], {LineBox[{{503., 20.263}, {503., 19.587}}], 
       LineBox[{
        Offset[{1.5, 0}, {503., 20.263}], Offset[{-1.5, 0}, {503., 20.263}]}],
        LineBox[{
        Offset[{1.5, 0}, {503., 19.587}], 
         Offset[{-1.5, 0}, {503., 19.587}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 187], {
       LineBox[{{517., 19.878999999999998`}, {517., 18.207}}], 
       LineBox[{
        Offset[{1.5, 0}, {517., 19.878999999999998`}], 
         Offset[{-1.5, 0}, {517., 19.878999999999998`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {517., 18.207}], 
         Offset[{-1.5, 0}, {517., 18.207}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 188], {LineBox[{{517., 5.618}, {517., 5.506}}], 
       LineBox[{
        Offset[{1.5, 0}, {517., 5.618}], Offset[{-1.5, 0}, {517., 5.618}]}], 
       LineBox[{
        Offset[{1.5, 0}, {517., 5.506}], 
         Offset[{-1.5, 0}, {517., 5.506}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 189], {
       LineBox[{{531., 19.668}, {531., 19.387999999999998`}}], 
       LineBox[{
        Offset[{1.5, 0}, {531., 19.668}], Offset[{-1.5, 0}, {531., 19.668}]}],
        LineBox[{
        Offset[{1.5, 0}, {531., 19.387999999999998`}], 
         Offset[{-1.5, 0}, {531., 19.387999999999998`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 190], {LineBox[{{562., 19.847}, {562., 19.695}}], 
       LineBox[{
        Offset[{1.5, 0}, {562., 19.847}], Offset[{-1.5, 0}, {562., 19.847}]}],
        LineBox[{
        Offset[{1.5, 0}, {562., 19.695}], 
         Offset[{-1.5, 0}, {562., 19.695}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 191], {LineBox[{{593., 19.571}, {593., 19.383}}], 
       LineBox[{
        Offset[{1.5, 0}, {593., 19.571}], Offset[{-1.5, 0}, {593., 19.571}]}],
        LineBox[{
        Offset[{1.5, 0}, {593., 19.383}], 
         Offset[{-1.5, 0}, {593., 19.383}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 192], {
       LineBox[{{621., 20.094}, {621., 18.381999999999998`}}], 
       LineBox[{
        Offset[{1.5, 0}, {621., 20.094}], Offset[{-1.5, 0}, {621., 20.094}]}],
        LineBox[{
        Offset[{1.5, 0}, {621., 18.381999999999998`}], 
         Offset[{-1.5, 0}, {621., 18.381999999999998`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 193], {LineBox[{{623., 5.554}, {623., 5.414}}], 
       LineBox[{
        Offset[{1.5, 0}, {623., 5.554}], Offset[{-1.5, 0}, {623., 5.554}]}], 
       LineBox[{
        Offset[{1.5, 0}, {623., 5.414}], 
         Offset[{-1.5, 0}, {623., 5.414}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 194], {LineBox[{{654., 19.744}, {654., 19.208}}], 
       LineBox[{
        Offset[{1.5, 0}, {654., 19.744}], Offset[{-1.5, 0}, {654., 19.744}]}],
        LineBox[{
        Offset[{1.5, 0}, {654., 19.208}], 
         Offset[{-1.5, 0}, {654., 19.208}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 195], {LineBox[{{714., 19.586}, {714., 19.4}}], 
       LineBox[{
        Offset[{1.5, 0}, {714., 19.586}], Offset[{-1.5, 0}, {714., 19.586}]}],
        LineBox[{
        Offset[{1.5, 0}, {714., 19.4}], Offset[{-1.5, 0}, {714., 19.4}]}]}}, {
      InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 196], {LineBox[{{734., 19.625}, {734., 17.891}}], 
       LineBox[{
        Offset[{1.5, 0}, {734., 19.625}], Offset[{-1.5, 0}, {734., 19.625}]}],
        LineBox[{
        Offset[{1.5, 0}, {734., 17.891}], 
         Offset[{-1.5, 0}, {734., 17.891}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 197], {LineBox[{{734., 5.465}, {734., 5.391}}], 
       LineBox[{
        Offset[{1.5, 0}, {734., 5.465}], Offset[{-1.5, 0}, {734., 5.465}]}], 
       LineBox[{
        Offset[{1.5, 0}, {734., 5.391}], 
         Offset[{-1.5, 0}, {734., 5.391}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 198], {
       LineBox[{{745., 19.168999999999997`}, {745., 18.939}}], 
       LineBox[{
        Offset[{1.5, 0}, {745., 19.168999999999997`}], 
         Offset[{-1.5, 0}, {745., 19.168999999999997`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {745., 18.939}], 
         Offset[{-1.5, 0}, {745., 18.939}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 199], {LineBox[{{767., 19.596}, {767., 19.508}}], 
       LineBox[{
        Offset[{1.5, 0}, {767., 19.596}], Offset[{-1.5, 0}, {767., 19.596}]}],
        LineBox[{
        Offset[{1.5, 0}, {767., 19.508}], 
         Offset[{-1.5, 0}, {767., 19.508}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 200], {
       LineBox[{{801., 19.043}, {801., 18.872999999999998`}}], 
       LineBox[{
        Offset[{1.5, 0}, {801., 19.043}], Offset[{-1.5, 0}, {801., 19.043}]}],
        LineBox[{
        Offset[{1.5, 0}, {801., 18.872999999999998`}], 
         Offset[{-1.5, 0}, {801., 18.872999999999998`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 201], {LineBox[{{864., 19.666}, {864., 19.358}}], 
       LineBox[{
        Offset[{1.5, 0}, {864., 19.666}], Offset[{-1.5, 0}, {864., 19.666}]}],
        LineBox[{
        Offset[{1.5, 0}, {864., 19.358}], 
         Offset[{-1.5, 0}, {864., 19.358}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 202], {
       LineBox[{{884., 19.110999999999997`}, {884., 17.619}}], 
       LineBox[{
        Offset[{1.5, 0}, {884., 19.110999999999997`}], 
         Offset[{-1.5, 0}, {884., 19.110999999999997`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {884., 17.619}], 
         Offset[{-1.5, 0}, {884., 17.619}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 203], {
       LineBox[{{957., 19.227999999999998`}, {957., 19.09}}], 
       LineBox[{
        Offset[{1.5, 0}, {957., 19.227999999999998`}], 
         Offset[{-1.5, 0}, {957., 19.227999999999998`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {957., 19.09}], 
         Offset[{-1.5, 0}, {957., 19.09}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 204], {
       LineBox[{{984., 19.601999999999997`}, {984., 19.494}}], 
       LineBox[{
        Offset[{1.5, 0}, {984., 19.601999999999997`}], 
         Offset[{-1.5, 0}, {984., 19.601999999999997`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {984., 19.494}], 
         Offset[{-1.5, 0}, {984., 19.494}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 205], {
       LineBox[{{986., 19.691}, {986., 17.538999999999998`}}], 
       LineBox[{
        Offset[{1.5, 0}, {986., 19.691}], Offset[{-1.5, 0}, {986., 19.691}]}],
        LineBox[{
        Offset[{1.5, 0}, {986., 17.538999999999998`}], 
         Offset[{-1.5, 0}, {986., 17.538999999999998`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 206], {
       LineBox[{{986., 5.5520000000000005`}, {986., 5.534}}], 
       LineBox[{
        Offset[{1.5, 0}, {986., 5.5520000000000005`}], 
         Offset[{-1.5, 0}, {986., 5.5520000000000005`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {986., 5.534}], 
         Offset[{-1.5, 0}, {986., 5.534}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 207], {
       LineBox[{{1020., 19.639999999999997`}, {1020., 19.532}}], 
       LineBox[{
        Offset[{1.5, 0}, {1020., 19.639999999999997`}], 
         Offset[{-1.5, 0}, {1020., 19.639999999999997`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1020., 19.532}], 
         Offset[{-1.5, 0}, {1020., 19.532}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 208], {LineBox[{{1090., 19.594}, {1090., 17.728}}], 
       LineBox[{
        Offset[{1.5, 0}, {1090., 19.594}], 
         Offset[{-1.5, 0}, {1090., 19.594}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1090., 17.728}], 
         Offset[{-1.5, 0}, {1090., 17.728}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 209], {LineBox[{{1091., 5.556}, {1091., 5.534}}], 
       LineBox[{
        Offset[{1.5, 0}, {1091., 5.556}], Offset[{-1.5, 0}, {1091., 5.556}]}],
        LineBox[{
        Offset[{1.5, 0}, {1091., 5.534}], 
         Offset[{-1.5, 0}, {1091., 5.534}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 210], {
       LineBox[{{1140., 19.301}, {1140., 19.205000000000002`}}], 
       LineBox[{
        Offset[{1.5, 0}, {1140., 19.301}], 
         Offset[{-1.5, 0}, {1140., 19.301}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1140., 19.205000000000002`}], 
         Offset[{-1.5, 0}, {1140., 19.205000000000002`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 211], {
       LineBox[{{1161., 19.63}, {1161., 17.721999999999998`}}], 
       LineBox[{
        Offset[{1.5, 0}, {1161., 19.63}], Offset[{-1.5, 0}, {1161., 19.63}]}],
        LineBox[{
        Offset[{1.5, 0}, {1161., 17.721999999999998`}], 
         Offset[{-1.5, 0}, {1161., 17.721999999999998`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 212], {
       LineBox[{{1161., 5.515000000000001}, {1161., 5.417}}], 
       LineBox[{
        Offset[{1.5, 0}, {1161., 5.515000000000001}], 
         Offset[{-1.5, 0}, {1161., 5.515000000000001}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1161., 5.417}], 
         Offset[{-1.5, 0}, {1161., 5.417}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 213], {LineBox[{{1172., 19.33}, {1172., 19.064}}], 
       LineBox[{
        Offset[{1.5, 0}, {1172., 19.33}], Offset[{-1.5, 0}, {1172., 19.33}]}],
        LineBox[{
        Offset[{1.5, 0}, {1172., 19.064}], 
         Offset[{-1.5, 0}, {1172., 19.064}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 214], {LineBox[{{1200., 19.141}, {1200., 18.805}}], 
       LineBox[{
        Offset[{1.5, 0}, {1200., 19.141}], 
         Offset[{-1.5, 0}, {1200., 19.141}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1200., 18.805}], 
         Offset[{-1.5, 0}, {1200., 18.805}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 215], {LineBox[{{1232., 19.2}, {1232., 18.996}}], 
       LineBox[{
        Offset[{1.5, 0}, {1232., 19.2}], Offset[{-1.5, 0}, {1232., 19.2}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1232., 18.996}], 
         Offset[{-1.5, 0}, {1232., 18.996}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 216], {LineBox[{{1259., 19.519}, {1259., 19.229}}], 
       LineBox[{
        Offset[{1.5, 0}, {1259., 19.519}], 
         Offset[{-1.5, 0}, {1259., 19.519}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1259., 19.229}], 
         Offset[{-1.5, 0}, {1259., 19.229}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 217], {LineBox[{{1280., 19.652}, {1280., 17.814}}], 
       LineBox[{
        Offset[{1.5, 0}, {1280., 19.652}], 
         Offset[{-1.5, 0}, {1280., 19.652}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1280., 17.814}], 
         Offset[{-1.5, 0}, {1280., 17.814}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 218], {LineBox[{{1280., 5.532}, {1280., 5.474}}], 
       LineBox[{
        Offset[{1.5, 0}, {1280., 5.532}], Offset[{-1.5, 0}, {1280., 5.532}]}],
        LineBox[{
        Offset[{1.5, 0}, {1280., 5.474}], 
         Offset[{-1.5, 0}, {1280., 5.474}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 219], {
       LineBox[{{1294., 19.647000000000002`}, {1294., 19.377}}], 
       LineBox[{
        Offset[{1.5, 0}, {1294., 19.647000000000002`}], 
         Offset[{-1.5, 0}, {1294., 19.647000000000002`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1294., 19.377}], 
         Offset[{-1.5, 0}, {1294., 19.377}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 220], {LineBox[{{1354., 19.858}, {1354., 19.548}}], 
       LineBox[{
        Offset[{1.5, 0}, {1354., 19.858}], 
         Offset[{-1.5, 0}, {1354., 19.858}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1354., 19.548}], 
         Offset[{-1.5, 0}, {1354., 19.548}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 221], {LineBox[{{1368., 20.591}, {1368., 20.351}}], 
       LineBox[{
        Offset[{1.5, 0}, {1368., 20.591}], 
         Offset[{-1.5, 0}, {1368., 20.591}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1368., 20.351}], 
         Offset[{-1.5, 0}, {1368., 20.351}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 222], {
       LineBox[{{1393., 5.5760000000000005`}, {1393., 5.532}}], 
       LineBox[{
        Offset[{1.5, 0}, {1393., 5.5760000000000005`}], 
         Offset[{-1.5, 0}, {1393., 5.5760000000000005`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1393., 5.532}], 
         Offset[{-1.5, 0}, {1393., 5.532}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 223], {LineBox[{{1393., 19.649}, {1393., 17.857}}], 
       LineBox[{
        Offset[{1.5, 0}, {1393., 19.649}], 
         Offset[{-1.5, 0}, {1393., 19.649}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1393., 17.857}], 
         Offset[{-1.5, 0}, {1393., 17.857}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 224], {
       LineBox[{{1415., 19.744}, {1415., 19.572000000000003`}}], 
       LineBox[{
        Offset[{1.5, 0}, {1415., 19.744}], 
         Offset[{-1.5, 0}, {1415., 19.744}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1415., 19.572000000000003`}], 
         Offset[{-1.5, 0}, {1415., 19.572000000000003`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 225], {LineBox[{{1447., 19.847}, {1447., 19.393}}], 
       LineBox[{
        Offset[{1.5, 0}, {1447., 19.847}], 
         Offset[{-1.5, 0}, {1447., 19.847}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1447., 19.393}], 
         Offset[{-1.5, 0}, {1447., 19.393}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 226], {
       LineBox[{{1464., 19.325}, {1464., 17.717000000000002`}}], 
       LineBox[{
        Offset[{1.5, 0}, {1464., 19.325}], 
         Offset[{-1.5, 0}, {1464., 19.325}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1464., 17.717000000000002`}], 
         Offset[{-1.5, 0}, {1464., 17.717000000000002`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 227], {
       LineBox[{{1505., 19.496000000000002`}, {1505., 18.79}}], 
       LineBox[{
        Offset[{1.5, 0}, {1505., 19.496000000000002`}], 
         Offset[{-1.5, 0}, {1505., 19.496000000000002`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1505., 18.79}], 
         Offset[{-1.5, 0}, {1505., 18.79}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 228], {
       LineBox[{{1535., 19.111}, {1535., 18.973000000000003`}}], 
       LineBox[{
        Offset[{1.5, 0}, {1535., 19.111}], 
         Offset[{-1.5, 0}, {1535., 19.111}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1535., 18.973000000000003`}], 
         Offset[{-1.5, 0}, {1535., 18.973000000000003`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 229], {
       LineBox[{{1567., 19.017}, {1567., 18.852999999999998`}}], 
       LineBox[{
        Offset[{1.5, 0}, {1567., 19.017}], 
         Offset[{-1.5, 0}, {1567., 19.017}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1567., 18.852999999999998`}], 
         Offset[{-1.5, 0}, {1567., 18.852999999999998`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 230], {
       LineBox[{{1577., 19.674}, {1577., 17.950000000000003`}}], 
       LineBox[{
        Offset[{1.5, 0}, {1577., 19.674}], 
         Offset[{-1.5, 0}, {1577., 19.674}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1577., 17.950000000000003`}], 
         Offset[{-1.5, 0}, {1577., 17.950000000000003`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 231], {
       LineBox[{{1576., 5.4830000000000005`}, {1576., 5.433}}], 
       LineBox[{
        Offset[{1.5, 0}, {1576., 5.4830000000000005`}], 
         Offset[{-1.5, 0}, {1576., 5.4830000000000005`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1576., 5.433}], 
         Offset[{-1.5, 0}, {1576., 5.433}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 232], {
       LineBox[{{1599., 19.48}, {1599., 18.983999999999998`}}], 
       LineBox[{
        Offset[{1.5, 0}, {1599., 19.48}], Offset[{-1.5, 0}, {1599., 19.48}]}],
        LineBox[{
        Offset[{1.5, 0}, {1599., 18.983999999999998`}], 
         Offset[{-1.5, 0}, {1599., 18.983999999999998`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 233], {LineBox[{{1657., 19.387}, {1657., 19.225}}], 
       LineBox[{
        Offset[{1.5, 0}, {1657., 19.387}], 
         Offset[{-1.5, 0}, {1657., 19.387}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1657., 19.225}], 
         Offset[{-1.5, 0}, {1657., 19.225}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 234], {
       LineBox[{{1682., 19.477999999999998`}, {1682., 17.578}}], 
       LineBox[{
        Offset[{1.5, 0}, {1682., 19.477999999999998`}], 
         Offset[{-1.5, 0}, {1682., 19.477999999999998`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1682., 17.578}], 
         Offset[{-1.5, 0}, {1682., 17.578}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 235], {
       LineBox[{{1684., 19.525000000000002`}, {1684., 19.401}}], 
       LineBox[{
        Offset[{1.5, 0}, {1684., 19.525000000000002`}], 
         Offset[{-1.5, 0}, {1684., 19.525000000000002`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1684., 19.401}], 
         Offset[{-1.5, 0}, {1684., 19.401}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 236], {LineBox[{{1689., 19.368}, {1689., 19.194}}], 
       LineBox[{
        Offset[{1.5, 0}, {1689., 19.368}], 
         Offset[{-1.5, 0}, {1689., 19.368}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1689., 19.194}], 
         Offset[{-1.5, 0}, {1689., 19.194}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 237], {
       LineBox[{{1750., 19.238}, {1750., 19.171999999999997`}}], 
       LineBox[{
        Offset[{1.5, 0}, {1750., 19.238}], 
         Offset[{-1.5, 0}, {1750., 19.238}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1750., 19.171999999999997`}], 
         Offset[{-1.5, 0}, {1750., 19.171999999999997`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 238], {
       LineBox[{{1762., 6.066999999999999}, {1762., 5.697}}], 
       LineBox[{
        Offset[{1.5, 0}, {1762., 6.066999999999999}], 
         Offset[{-1.5, 0}, {1762., 6.066999999999999}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1762., 5.697}], 
         Offset[{-1.5, 0}, {1762., 5.697}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 239], {
       LineBox[{{1763., 19.358999999999998`}, {1763., 17.687}}], 
       LineBox[{
        Offset[{1.5, 0}, {1763., 19.358999999999998`}], 
         Offset[{-1.5, 0}, {1763., 19.358999999999998`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1763., 17.687}], 
         Offset[{-1.5, 0}, {1763., 17.687}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 240], {
       LineBox[{{1777., 19.206000000000003`}, {1777., 19.128}}], 
       LineBox[{
        Offset[{1.5, 0}, {1777., 19.206000000000003`}], 
         Offset[{-1.5, 0}, {1777., 19.206000000000003`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1777., 19.128}], 
         Offset[{-1.5, 0}, {1777., 19.128}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 241], {
       LineBox[{{1810., 19.191000000000003`}, {1810., 19.037}}], 
       LineBox[{
        Offset[{1.5, 0}, {1810., 19.191000000000003`}], 
         Offset[{-1.5, 0}, {1810., 19.191000000000003`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1810., 19.037}], 
         Offset[{-1.5, 0}, {1810., 19.037}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 242], {LineBox[{{1819., 19.267}, {1819., 17.425}}], 
       LineBox[{
        Offset[{1.5, 0}, {1819., 19.267}], 
         Offset[{-1.5, 0}, {1819., 19.267}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1819., 17.425}], 
         Offset[{-1.5, 0}, {1819., 17.425}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 243], {LineBox[{{1818., 5.436}, {1818., 5.404}}], 
       LineBox[{
        Offset[{1.5, 0}, {1818., 5.436}], Offset[{-1.5, 0}, {1818., 5.436}]}],
        LineBox[{
        Offset[{1.5, 0}, {1818., 5.404}], 
         Offset[{-1.5, 0}, {1818., 5.404}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 244], {
       LineBox[{{1841., 19.683}, {1841., 19.098999999999997`}}], 
       LineBox[{
        Offset[{1.5, 0}, {1841., 19.683}], 
         Offset[{-1.5, 0}, {1841., 19.683}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1841., 19.098999999999997`}], 
         Offset[{-1.5, 0}, {1841., 19.098999999999997`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 245], {
       LineBox[{{1934., 19.962}, {1934., 17.605999999999998`}}], 
       LineBox[{
        Offset[{1.5, 0}, {1934., 19.962}], 
         Offset[{-1.5, 0}, {1934., 19.962}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1934., 17.605999999999998`}], 
         Offset[{-1.5, 0}, {1934., 17.605999999999998`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 246], {
       LineBox[{{1933., 5.4239999999999995`}, {1933., 5.414}}], 
       LineBox[{
        Offset[{1.5, 0}, {1933., 5.4239999999999995`}], 
         Offset[{-1.5, 0}, {1933., 5.4239999999999995`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1933., 5.414}], 
         Offset[{-1.5, 0}, {1933., 5.414}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 247], {
       LineBox[{{1963., 19.12}, {1963., 18.849999999999998`}}], 
       LineBox[{
        Offset[{1.5, 0}, {1963., 19.12}], Offset[{-1.5, 0}, {1963., 19.12}]}],
        LineBox[{
        Offset[{1.5, 0}, {1963., 18.849999999999998`}], 
         Offset[{-1.5, 0}, {1963., 18.849999999999998`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 248], {LineBox[{{2017., 19.215}, {2017., 16.965}}], 
       LineBox[{
        Offset[{1.5, 0}, {2017., 19.215}], 
         Offset[{-1.5, 0}, {2017., 19.215}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2017., 16.965}], 
         Offset[{-1.5, 0}, {2017., 16.965}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 249], {LineBox[{{2017., 5.443}, {2017., 5.395}}], 
       LineBox[{
        Offset[{1.5, 0}, {2017., 5.443}], Offset[{-1.5, 0}, {2017., 5.443}]}],
        LineBox[{
        Offset[{1.5, 0}, {2017., 5.395}], 
         Offset[{-1.5, 0}, {2017., 5.395}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 250], {
       LineBox[{{2022., 19.38}, {2022., 19.215999999999998`}}], 
       LineBox[{
        Offset[{1.5, 0}, {2022., 19.38}], Offset[{-1.5, 0}, {2022., 19.38}]}],
        LineBox[{
        Offset[{1.5, 0}, {2022., 19.215999999999998`}], 
         Offset[{-1.5, 0}, {2022., 19.215999999999998`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 251], {
       LineBox[{{2053., 19.156}, {2053., 19.048000000000002`}}], 
       LineBox[{
        Offset[{1.5, 0}, {2053., 19.156}], 
         Offset[{-1.5, 0}, {2053., 19.156}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2053., 19.048000000000002`}], 
         Offset[{-1.5, 0}, {2053., 19.048000000000002`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 252], {LineBox[{{2082., 19.158}, {2082., 19.052}}], 
       LineBox[{
        Offset[{1.5, 0}, {2082., 19.158}], 
         Offset[{-1.5, 0}, {2082., 19.158}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2082., 19.052}], 
         Offset[{-1.5, 0}, {2082., 19.052}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 253], {
       LineBox[{{2109., 19.281000000000002`}, {2109., 17.297}}], 
       LineBox[{
        Offset[{1.5, 0}, {2109., 19.281000000000002`}], 
         Offset[{-1.5, 0}, {2109., 19.281000000000002`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2109., 17.297}], 
         Offset[{-1.5, 0}, {2109., 17.297}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 254], {LineBox[{{2109., 5.431}, {2109., 5.393}}], 
       LineBox[{
        Offset[{1.5, 0}, {2109., 5.431}], Offset[{-1.5, 0}, {2109., 5.431}]}],
        LineBox[{
        Offset[{1.5, 0}, {2109., 5.393}], 
         Offset[{-1.5, 0}, {2109., 5.393}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 255], {LineBox[{{2113., 19.695}, {2113., 19.503}}], 
       LineBox[{
        Offset[{1.5, 0}, {2113., 19.695}], 
         Offset[{-1.5, 0}, {2113., 19.695}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2113., 19.503}], 
         Offset[{-1.5, 0}, {2113., 19.503}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 256], {LineBox[{{2144., 19.336}, {2144., 19.07}}], 
       LineBox[{
        Offset[{1.5, 0}, {2144., 19.336}], 
         Offset[{-1.5, 0}, {2144., 19.336}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2144., 19.07}], 
         Offset[{-1.5, 0}, {2144., 19.07}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 257], {
       LineBox[{{2176., 19.166}, {2176., 19.046000000000003`}}], 
       LineBox[{
        Offset[{1.5, 0}, {2176., 19.166}], 
         Offset[{-1.5, 0}, {2176., 19.166}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2176., 19.046000000000003`}], 
         Offset[{-1.5, 0}, {2176., 19.046000000000003`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 258], {LineBox[{{2207., 19.426}, {2207., 19.242}}], 
       LineBox[{
        Offset[{1.5, 0}, {2207., 19.426}], 
         Offset[{-1.5, 0}, {2207., 19.426}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2207., 19.242}], 
         Offset[{-1.5, 0}, {2207., 19.242}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 259], {LineBox[{{2218., 19.316}, {2218., 17.682}}], 
       LineBox[{
        Offset[{1.5, 0}, {2218., 19.316}], 
         Offset[{-1.5, 0}, {2218., 19.316}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2218., 17.682}], 
         Offset[{-1.5, 0}, {2218., 17.682}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 260], {LineBox[{{2218., 5.526}, {2218., 5.446}}], 
       LineBox[{
        Offset[{1.5, 0}, {2218., 5.526}], Offset[{-1.5, 0}, {2218., 5.526}]}],
        LineBox[{
        Offset[{1.5, 0}, {2218., 5.446}], 
         Offset[{-1.5, 0}, {2218., 5.446}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 261], {
       LineBox[{{2235., 18.974999999999998`}, {2235., 18.807}}], 
       LineBox[{
        Offset[{1.5, 0}, {2235., 18.974999999999998`}], 
         Offset[{-1.5, 0}, {2235., 18.974999999999998`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2235., 18.807}], 
         Offset[{-1.5, 0}, {2235., 18.807}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 262], {LineBox[{{2293., 19.037}, {2293., 17.509}}], 
       LineBox[{
        Offset[{1.5, 0}, {2293., 19.037}], 
         Offset[{-1.5, 0}, {2293., 19.037}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2293., 17.509}], 
         Offset[{-1.5, 0}, {2293., 17.509}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 263], {LineBox[{{2292., 5.427}, {2292., 5.353}}], 
       LineBox[{
        Offset[{1.5, 0}, {2292., 5.427}], Offset[{-1.5, 0}, {2292., 5.427}]}],
        LineBox[{
        Offset[{1.5, 0}, {2292., 5.353}], 
         Offset[{-1.5, 0}, {2292., 5.353}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 264], {LineBox[{{2296., 19.082}, {2296., 18.97}}], 
       LineBox[{
        Offset[{1.5, 0}, {2296., 19.082}], 
         Offset[{-1.5, 0}, {2296., 19.082}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2296., 18.97}], 
         Offset[{-1.5, 0}, {2296., 18.97}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 265], {
       LineBox[{{2326., 19.407999999999998`}, {2326., 19.224}}], 
       LineBox[{
        Offset[{1.5, 0}, {2326., 19.407999999999998`}], 
         Offset[{-1.5, 0}, {2326., 19.407999999999998`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2326., 19.224}], 
         Offset[{-1.5, 0}, {2326., 19.224}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 266], {LineBox[{{2358., 18.904}, {2358., 18.798}}], 
       LineBox[{
        Offset[{1.5, 0}, {2358., 18.904}], 
         Offset[{-1.5, 0}, {2358., 18.904}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2358., 18.798}], 
         Offset[{-1.5, 0}, {2358., 18.798}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 267], {LineBox[{{2388., 19.179}, {2388., 19.081}}], 
       LineBox[{
        Offset[{1.5, 0}, {2388., 19.179}], 
         Offset[{-1.5, 0}, {2388., 19.179}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2388., 19.081}], 
         Offset[{-1.5, 0}, {2388., 19.081}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 268], {
       LineBox[{{2401., 18.869}, {2401., 17.168999999999997`}}], 
       LineBox[{
        Offset[{1.5, 0}, {2401., 18.869}], 
         Offset[{-1.5, 0}, {2401., 18.869}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2401., 17.168999999999997`}], 
         Offset[{-1.5, 0}, {2401., 17.168999999999997`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 269], {
       LineBox[{{2449., 18.964000000000002`}, {2449., 18.752}}], 
       LineBox[{
        Offset[{1.5, 0}, {2449., 18.964000000000002`}], 
         Offset[{-1.5, 0}, {2449., 18.964000000000002`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2449., 18.752}], 
         Offset[{-1.5, 0}, {2449., 18.752}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 270], {LineBox[{{2481., 18.648}, {2481., 18.508}}], 
       LineBox[{
        Offset[{1.5, 0}, {2481., 18.648}], 
         Offset[{-1.5, 0}, {2481., 18.648}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2481., 18.508}], 
         Offset[{-1.5, 0}, {2481., 18.508}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 271], {
       LineBox[{{2492., 18.816000000000003`}, {2492., 16.982}}], 
       LineBox[{
        Offset[{1.5, 0}, {2492., 18.816000000000003`}], 
         Offset[{-1.5, 0}, {2492., 18.816000000000003`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2492., 16.982}], 
         Offset[{-1.5, 0}, {2492., 16.982}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 272], {
       LineBox[{{2492., 5.3229999999999995`}, {2492., 5.277}}], 
       LineBox[{
        Offset[{1.5, 0}, {2492., 5.3229999999999995`}], 
         Offset[{-1.5, 0}, {2492., 5.3229999999999995`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2492., 5.277}], 
         Offset[{-1.5, 0}, {2492., 5.277}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 273], {LineBox[{{2510., 18.59}, {2510., 18.538}}], 
       LineBox[{
        Offset[{1.5, 0}, {2510., 18.59}], Offset[{-1.5, 0}, {2510., 18.59}]}],
        LineBox[{
        Offset[{1.5, 0}, {2510., 18.538}], 
         Offset[{-1.5, 0}, {2510., 18.538}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 274], {
       LineBox[{{2542., 19.213}, {2542., 18.808999999999997`}}], 
       LineBox[{
        Offset[{1.5, 0}, {2542., 19.213}], 
         Offset[{-1.5, 0}, {2542., 19.213}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2542., 18.808999999999997`}], 
         Offset[{-1.5, 0}, {2542., 18.808999999999997`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 275], {
       LineBox[{{2574., 18.567999999999998`}, {2574., 18.454}}], 
       LineBox[{
        Offset[{1.5, 0}, {2574., 18.567999999999998`}], 
         Offset[{-1.5, 0}, {2574., 18.567999999999998`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2574., 18.454}], 
         Offset[{-1.5, 0}, {2574., 18.454}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 276], {LineBox[{{2583., 18.929}, {2583., 17.251}}], 
       LineBox[{
        Offset[{1.5, 0}, {2583., 18.929}], 
         Offset[{-1.5, 0}, {2583., 18.929}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2583., 17.251}], 
         Offset[{-1.5, 0}, {2583., 17.251}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 277], {LineBox[{{2582., 5.35}, {2582., 5.346}}], 
       LineBox[{
        Offset[{1.5, 0}, {2582., 5.35}], Offset[{-1.5, 0}, {2582., 5.35}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2582., 5.346}], 
         Offset[{-1.5, 0}, {2582., 5.346}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 278], {LineBox[{{2601., 18.902}, {2601., 18.79}}], 
       LineBox[{
        Offset[{1.5, 0}, {2601., 18.902}], 
         Offset[{-1.5, 0}, {2601., 18.902}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2601., 18.79}], 
         Offset[{-1.5, 0}, {2601., 18.79}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 279], {LineBox[{{2632., 18.5}, {2632., 18.308}}], 
       LineBox[{
        Offset[{1.5, 0}, {2632., 18.5}], Offset[{-1.5, 0}, {2632., 18.5}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2632., 18.308}], 
         Offset[{-1.5, 0}, {2632., 18.308}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 280], {LineBox[{{2662., 18.528}, {2662., 18.436}}], 
       LineBox[{
        Offset[{1.5, 0}, {2662., 18.528}], 
         Offset[{-1.5, 0}, {2662., 18.528}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2662., 18.436}], 
         Offset[{-1.5, 0}, {2662., 18.436}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 281], {LineBox[{{2675., 18.797}, {2675., 17.263}}], 
       LineBox[{
        Offset[{1.5, 0}, {2675., 18.797}], 
         Offset[{-1.5, 0}, {2675., 18.797}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2675., 17.263}], 
         Offset[{-1.5, 0}, {2675., 17.263}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 282], {
       LineBox[{{2674., 5.359999999999999}, {2674., 5.324}}], 
       LineBox[{
        Offset[{1.5, 0}, {2674., 5.359999999999999}], 
         Offset[{-1.5, 0}, {2674., 5.359999999999999}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2674., 5.324}], 
         Offset[{-1.5, 0}, {2674., 5.324}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 283], {LineBox[{{2755., 18.929}, {2755., 18.803}}], 
       LineBox[{
        Offset[{1.5, 0}, {2755., 18.929}], 
         Offset[{-1.5, 0}, {2755., 18.929}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2755., 18.803}], 
         Offset[{-1.5, 0}, {2755., 18.803}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 284], {
       LineBox[{{2761., 18.453000000000003`}, {2761., 16.735}}], 
       LineBox[{
        Offset[{1.5, 0}, {2761., 18.453000000000003`}], 
         Offset[{-1.5, 0}, {2761., 18.453000000000003`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2761., 16.735}], 
         Offset[{-1.5, 0}, {2761., 16.735}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 285], {LineBox[{{2761., 5.419}, {2761., 5.361}}], 
       LineBox[{
        Offset[{1.5, 0}, {2761., 5.419}], Offset[{-1.5, 0}, {2761., 5.419}]}],
        LineBox[{
        Offset[{1.5, 0}, {2761., 5.361}], 
         Offset[{-1.5, 0}, {2761., 5.361}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 286], {LineBox[{{2814., 18.903}, {2814., 18.707}}], 
       LineBox[{
        Offset[{1.5, 0}, {2814., 18.903}], 
         Offset[{-1.5, 0}, {2814., 18.903}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2814., 18.707}], 
         Offset[{-1.5, 0}, {2814., 18.707}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 287], {
       LineBox[{{2838., 5.361999999999999}, {2838., 5.338}}], 
       LineBox[{
        Offset[{1.5, 0}, {2838., 5.361999999999999}], 
         Offset[{-1.5, 0}, {2838., 5.361999999999999}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2838., 5.338}], 
         Offset[{-1.5, 0}, {2838., 5.338}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 288], {
       LineBox[{{2838., 18.733}, {2838., 17.223000000000003`}}], 
       LineBox[{
        Offset[{1.5, 0}, {2838., 18.733}], 
         Offset[{-1.5, 0}, {2838., 18.733}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2838., 17.223000000000003`}], 
         Offset[{-1.5, 0}, {2838., 17.223000000000003`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 289], {
       LineBox[{{2848., 20.645}, {2848., 20.532999999999998`}}], 
       LineBox[{
        Offset[{1.5, 0}, {2848., 20.645}], 
         Offset[{-1.5, 0}, {2848., 20.645}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2848., 20.532999999999998`}], 
         Offset[{-1.5, 0}, {2848., 20.532999999999998`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 290], {
       LineBox[{{2875., 20.645}, {2875., 20.532999999999998`}}], 
       LineBox[{
        Offset[{1.5, 0}, {2875., 20.645}], 
         Offset[{-1.5, 0}, {2875., 20.645}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2875., 20.532999999999998`}], 
         Offset[{-1.5, 0}, {2875., 20.532999999999998`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 291], {
       LineBox[{{2938., 20.480999999999998`}, {2938., 20.233}}], 
       LineBox[{
        Offset[{1.5, 0}, {2938., 20.480999999999998`}], 
         Offset[{-1.5, 0}, {2938., 20.480999999999998`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2938., 20.233}], 
         Offset[{-1.5, 0}, {2938., 20.233}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 292], {LineBox[{{2941., 20.296}, {2941., 18.674}}], 
       LineBox[{
        Offset[{1.5, 0}, {2941., 20.296}], 
         Offset[{-1.5, 0}, {2941., 20.296}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2941., 18.674}], 
         Offset[{-1.5, 0}, {2941., 18.674}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 293], {LineBox[{{2940., 5.816}, {2940., 5.774}}], 
       LineBox[{
        Offset[{1.5, 0}, {2940., 5.816}], Offset[{-1.5, 0}, {2940., 5.816}]}],
        LineBox[{
        Offset[{1.5, 0}, {2940., 5.774}], 
         Offset[{-1.5, 0}, {2940., 5.774}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 294], {
       LineBox[{{2966., 20.41}, {2966., 20.203999999999997`}}], 
       LineBox[{
        Offset[{1.5, 0}, {2966., 20.41}], Offset[{-1.5, 0}, {2966., 20.41}]}],
        LineBox[{
        Offset[{1.5, 0}, {2966., 20.203999999999997`}], 
         Offset[{-1.5, 0}, {2966., 20.203999999999997`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 295], {
       LineBox[{{2997., 20.415000000000003`}, {2997., 20.053}}], 
       LineBox[{
        Offset[{1.5, 0}, {2997., 20.415000000000003`}], 
         Offset[{-1.5, 0}, {2997., 20.415000000000003`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2997., 20.053}], 
         Offset[{-1.5, 0}, {2997., 20.053}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 296], {LineBox[{{3025., 20.348}, {3025., 20.186}}], 
       LineBox[{
        Offset[{1.5, 0}, {3025., 20.348}], 
         Offset[{-1.5, 0}, {3025., 20.348}]}], 
       LineBox[{
        Offset[{1.5, 0}, {3025., 20.186}], 
         Offset[{-1.5, 0}, {3025., 20.186}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 297], {
       LineBox[{{3043., 20.331999999999997`}, {3043., 18.834}}], 
       LineBox[{
        Offset[{1.5, 0}, {3043., 20.331999999999997`}], 
         Offset[{-1.5, 0}, {3043., 20.331999999999997`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {3043., 18.834}], 
         Offset[{-1.5, 0}, {3043., 18.834}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 298], {LineBox[{{3043., 5.492}, {3043., 5.206}}], 
       LineBox[{
        Offset[{1.5, 0}, {3043., 5.492}], Offset[{-1.5, 0}, {3043., 5.492}]}],
        LineBox[{
        Offset[{1.5, 0}, {3043., 5.206}], 
         Offset[{-1.5, 0}, {3043., 5.206}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 299], {
       LineBox[{{3063., 20.314}, {3063., 20.055999999999997`}}], 
       LineBox[{
        Offset[{1.5, 0}, {3063., 20.314}], 
         Offset[{-1.5, 0}, {3063., 20.314}]}], 
       LineBox[{
        Offset[{1.5, 0}, {3063., 20.055999999999997`}], 
         Offset[{-1.5, 0}, {3063., 20.055999999999997`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 300], {
       LineBox[{{3090., 20.337}, {3090., 20.148999999999997`}}], 
       LineBox[{
        Offset[{1.5, 0}, {3090., 20.337}], 
         Offset[{-1.5, 0}, {3090., 20.337}]}], 
       LineBox[{
        Offset[{1.5, 0}, {3090., 20.148999999999997`}], 
         Offset[{-1.5, 0}, {3090., 20.148999999999997`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 301], {LineBox[{{3139., 20.225}, {3139., 18.485}}], 
       LineBox[{
        Offset[{1.5, 0}, {3139., 20.225}], 
         Offset[{-1.5, 0}, {3139., 20.225}]}], 
       LineBox[{
        Offset[{1.5, 0}, {3139., 18.485}], 
         Offset[{-1.5, 0}, {3139., 18.485}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 302], {
       LineBox[{{3139., 5.848}, {3139., 5.787999999999999}}], 
       LineBox[{
        Offset[{1.5, 0}, {3139., 5.848}], Offset[{-1.5, 0}, {3139., 5.848}]}],
        LineBox[{
        Offset[{1.5, 0}, {3139., 5.787999999999999}], 
         Offset[{-1.5, 0}, {3139., 5.787999999999999}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 303], {
       LineBox[{{3151., 20.421}, {3151., 20.319000000000003`}}], 
       LineBox[{
        Offset[{1.5, 0}, {3151., 20.421}], 
         Offset[{-1.5, 0}, {3151., 20.421}]}], 
       LineBox[{
        Offset[{1.5, 0}, {3151., 20.319000000000003`}], 
         Offset[{-1.5, 0}, {3151., 20.319000000000003`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 304], {LineBox[{{3182., 20.469}, {3182., 20.287}}], 
       LineBox[{
        Offset[{1.5, 0}, {3182., 20.469}], 
         Offset[{-1.5, 0}, {3182., 20.469}]}], 
       LineBox[{
        Offset[{1.5, 0}, {3182., 20.287}], 
         Offset[{-1.5, 0}, {3182., 20.287}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 305], {LineBox[{{3209., 20.596}, {3209., 18.946}}], 
       LineBox[{
        Offset[{1.5, 0}, {3209., 20.596}], 
         Offset[{-1.5, 0}, {3209., 20.596}]}], 
       LineBox[{
        Offset[{1.5, 0}, {3209., 18.946}], 
         Offset[{-1.5, 0}, {3209., 18.946}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 306], {
       LineBox[{{3214., 20.516000000000002`}, {3214., 20.334}}], 
       LineBox[{
        Offset[{1.5, 0}, {3214., 20.516000000000002`}], 
         Offset[{-1.5, 0}, {3214., 20.516000000000002`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {3214., 20.334}], 
         Offset[{-1.5, 0}, {3214., 20.334}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 307], {
       LineBox[{{3243., 20.267}, {3243., 20.159000000000002`}}], 
       LineBox[{
        Offset[{1.5, 0}, {3243., 20.267}], 
         Offset[{-1.5, 0}, {3243., 20.267}]}], 
       LineBox[{
        Offset[{1.5, 0}, {3243., 20.159000000000002`}], 
         Offset[{-1.5, 0}, {3243., 20.159000000000002`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 308], {LineBox[{{3274., 20.435}, {3274., 20.199}}], 
       LineBox[{
        Offset[{1.5, 0}, {3274., 20.435}], 
         Offset[{-1.5, 0}, {3274., 20.435}]}], 
       LineBox[{
        Offset[{1.5, 0}, {3274., 20.199}], 
         Offset[{-1.5, 0}, {3274., 20.199}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 309], {
       LineBox[{{3304., 20.520000000000003`}, {3304., 20.378}}], 
       LineBox[{
        Offset[{1.5, 0}, {3304., 20.520000000000003`}], 
         Offset[{-1.5, 0}, {3304., 20.520000000000003`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {3304., 20.378}], 
         Offset[{-1.5, 0}, {3304., 20.378}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 310], {
       LineBox[{{3314., 20.631999999999998`}, {3314., 18.826}}], 
       LineBox[{
        Offset[{1.5, 0}, {3314., 20.631999999999998`}], 
         Offset[{-1.5, 0}, {3314., 20.631999999999998`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {3314., 18.826}], 
         Offset[{-1.5, 0}, {3314., 18.826}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 311], {LineBox[{{3331., 20.446}, {3331., 20.248}}], 
       LineBox[{
        Offset[{1.5, 0}, {3331., 20.446}], 
         Offset[{-1.5, 0}, {3331., 20.446}]}], 
       LineBox[{
        Offset[{1.5, 0}, {3331., 20.248}], 
         Offset[{-1.5, 0}, {3331., 20.248}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 312], {LineBox[{{3362., 20.238}, {3362., 20.046}}], 
       LineBox[{
        Offset[{1.5, 0}, {3362., 20.238}], 
         Offset[{-1.5, 0}, {3362., 20.238}]}], 
       LineBox[{
        Offset[{1.5, 0}, {3362., 20.046}], 
         Offset[{-1.5, 0}, {3362., 20.046}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 313], {LineBox[{{3390., 20.339}, {3390., 20.189}}], 
       LineBox[{
        Offset[{1.5, 0}, {3390., 20.339}], 
         Offset[{-1.5, 0}, {3390., 20.339}]}], 
       LineBox[{
        Offset[{1.5, 0}, {3390., 20.189}], 
         Offset[{-1.5, 0}, {3390., 20.189}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 314], {
       LineBox[{{3454., 20.354}, {3454., 20.176000000000002`}}], 
       LineBox[{
        Offset[{1.5, 0}, {3454., 20.354}], 
         Offset[{-1.5, 0}, {3454., 20.354}]}], 
       LineBox[{
        Offset[{1.5, 0}, {3454., 20.176000000000002`}], 
         Offset[{-1.5, 0}, {3454., 20.176000000000002`}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 315], {LineBox[{{3510., 20.335}, {3510., 18.671}}], 
       LineBox[{
        Offset[{1.5, 0}, {3510., 20.335}], 
         Offset[{-1.5, 0}, {3510., 20.335}]}], 
       LineBox[{
        Offset[{1.5, 0}, {3510., 18.671}], 
         Offset[{-1.5, 0}, {3510., 18.671}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 316], {
       LineBox[{{3510., 5.726999999999999}, {3510., 5.723}}], 
       LineBox[{
        Offset[{1.5, 0}, {3510., 5.726999999999999}], 
         Offset[{-1.5, 0}, {3510., 5.726999999999999}]}], 
       LineBox[{
        Offset[{1.5, 0}, {3510., 5.723}], 
         Offset[{-1.5, 0}, {3510., 5.723}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 317], {
       LineBox[{{3517., 20.319999999999997`}, {3517., 20.224}}], 
       LineBox[{
        Offset[{1.5, 0}, {3517., 20.319999999999997`}], 
         Offset[{-1.5, 0}, {3517., 20.319999999999997`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {3517., 20.224}], 
         Offset[{-1.5, 0}, {3517., 20.224}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 318], {
       LineBox[{{3577., 20.514999999999997`}, {3577., 20.355}}], 
       LineBox[{
        Offset[{1.5, 0}, {3577., 20.514999999999997`}], 
         Offset[{-1.5, 0}, {3577., 20.514999999999997`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {3577., 20.355}], 
         Offset[{-1.5, 0}, {3577., 20.355}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 319], {LineBox[{{3594., 5.827}, {3594., 5.795}}], 
       LineBox[{
        Offset[{1.5, 0}, {3594., 5.827}], Offset[{-1.5, 0}, {3594., 5.827}]}],
        LineBox[{
        Offset[{1.5, 0}, {3594., 5.795}], 
         Offset[{-1.5, 0}, {3594., 5.795}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 320], {
       LineBox[{{3596., 20.461000000000002`}, {3596., 19.053}}], 
       LineBox[{
        Offset[{1.5, 0}, {3596., 20.461000000000002`}], 
         Offset[{-1.5, 0}, {3596., 20.461000000000002`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {3596., 19.053}], 
         Offset[{-1.5, 0}, {3596., 19.053}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 321], {LineBox[{{3606., 21.034}, {3606., 20.83}}], 
       LineBox[{
        Offset[{1.5, 0}, {3606., 21.034}], 
         Offset[{-1.5, 0}, {3606., 21.034}]}], 
       LineBox[{
        Offset[{1.5, 0}, {3606., 20.83}], 
         Offset[{-1.5, 0}, {3606., 20.83}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 322], {LineBox[{{3637., 20.759}, {3637., 20.585}}], 
       LineBox[{
        Offset[{1.5, 0}, {3637., 20.759}], 
         Offset[{-1.5, 0}, {3637., 20.759}]}], 
       LineBox[{
        Offset[{1.5, 0}, {3637., 20.585}], 
         Offset[{-1.5, 0}, {3637., 20.585}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 323], {LineBox[{{3668., 20.433}, {3668., 20.281}}], 
       LineBox[{
        Offset[{1.5, 0}, {3668., 20.433}], 
         Offset[{-1.5, 0}, {3668., 20.433}]}], 
       LineBox[{
        Offset[{1.5, 0}, {3668., 20.281}], 
         Offset[{-1.5, 0}, {3668., 20.281}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 324], {LineBox[{{3694., 20.531}, {3694., 18.601}}], 
       LineBox[{
        Offset[{1.5, 0}, {3694., 20.531}], 
         Offset[{-1.5, 0}, {3694., 20.531}]}], 
       LineBox[{
        Offset[{1.5, 0}, {3694., 18.601}], 
         Offset[{-1.5, 0}, {3694., 18.601}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 325], {
       LineBox[{{3693., 5.8149999999999995`}, {3693., 5.795}}], 
       LineBox[{
        Offset[{1.5, 0}, {3693., 5.8149999999999995`}], 
         Offset[{-1.5, 0}, {3693., 5.8149999999999995`}]}], 
       LineBox[{
        Offset[{1.5, 0}, {3693., 5.795}], 
         Offset[{-1.5, 0}, {3693., 5.795}]}]}}, {InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 326], {
       LineBox[{{3695., 20.38}, {3695., 20.169999999999998`}}], 
       LineBox[{
        Offset[{1.5, 0}, {3695., 20.38}], Offset[{-1.5, 0}, {3695., 20.38}]}],
        LineBox[{
        Offset[{1.5, 0}, {3695., 20.169999999999998`}], 
         Offset[{-1.5, 0}, {3695., 20.169999999999998`}]}]}}}, {}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  Frame->True,
  FrameLabel->{{
     FormBox["\"Coeff. calibratio Ouest (Jy)\"", TraditionalForm], 
     FormBox["\"\"", TraditionalForm]}, {
     FormBox["\"Jour depuis 31 Jan. 2001\"", TraditionalForm], 
     FormBox["\"1410 MHz\"", TraditionalForm]}},
  GridLines->Automatic,
  ImageSize->{866., Automatic},
  LabelStyle->Directive[
    RGBColor[0, 0, 1], Large],
  PlotRange->{All, {0, 25}},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.5104811085131197`*^9, 3.5104811490941772`*^9}}]
}, Open  ]]
},
WindowSize->{990, 761},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (November 7, 2010)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 180, 3, 31, "Input"],
Cell[740, 25, 179, 3, 52, InheritFromParent],
Cell[922, 30, 53, 1, 31, "Input"],
Cell[978, 33, 266, 7, 31, "Input"],
Cell[1247, 42, 79, 1, 31, "Input"],
Cell[1329, 45, 2119, 53, 92, "Input"],
Cell[CellGroupData[{
Cell[3473, 102, 1266, 28, 72, "Input"],
Cell[4742, 132, 67585, 1545, 597, "Output"]
}, Open  ]],
Cell[72342, 1680, 242, 6, 31, "Input"],
Cell[72587, 1688, 1727, 48, 92, "Input"],
Cell[CellGroupData[{
Cell[74339, 1740, 937, 24, 72, "Input"],
Cell[75279, 1766, 67411, 1548, 589, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
